/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTech_API;
import gregtech.api.enums.GT_HatchElement;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IGlobalWirelessEnergy;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_EnhancedMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Multiblock_Tooltip_Builder;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_StructureUtility;
import gregtech.common.items.GT_IntegratedCircuit_Item;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

public class GT_MetaTileEntity_TranscendentPlasmaMixer
extends GT_MetaTileEntity_EnhancedMultiBlockBase<GT_MetaTileEntity_TranscendentPlasmaMixer>
implements IGlobalWirelessEnergy,
ISurvivalConstructable {
    private static final String[][] structure = new String[][]{{" CAC ", " ABA ", " ABA ", " A~A ", " ABA ", " ABA ", " CAC "}, {"CBBBC", "A   A", "A   A", "A   A", "A   A", "A   A", "CBBBC"}, {"ABBBA", "B   B", "B   B", "B   B", "B   B", "B   B", "ABBBA"}, {"CBBBC", "A   A", "A   A", "A   A", "A   A", "A   A", "CBBBC"}, {" CAC ", " ABA ", " ABA ", " ABA ", " ABA ", " ABA ", " CAC "}};
    private static final String STRUCTURE_PIECE_MAIN = "MAIN";
    private static final IStructureDefinition<GT_MetaTileEntity_TranscendentPlasmaMixer> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("MAIN", structure).addElement('B', GT_StructureUtility.buildHatchAdder(GT_MetaTileEntity_TranscendentPlasmaMixer.class).atLeast(GT_HatchElement.InputHatch, GT_HatchElement.OutputHatch, GT_HatchElement.InputBus, GT_HatchElement.Maintenance).casingIndex(13).dot(1).buildAndChain(GregTech_API.sBlockCasings1, 13)).addElement('A', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)12)).addElement('C', StructureUtility.ofBlock((Block)GregTech_API.sBlockCasings1, (int)14)).build();
    private String ownerUUID;
    int multiplier = 1;
    long mWirelessEUt = 0L;
    private static final int HORIZONTAL_OFFSET = 2;
    private static final int VERTICAL_OFFSET = 3;
    private static final int DEPTH_OFFSET = 0;

    public GT_MetaTileEntity_TranscendentPlasmaMixer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public GT_MetaTileEntity_TranscendentPlasmaMixer(String aName) {
        super(aName);
    }

    @Override
    public IStructureDefinition<GT_MetaTileEntity_TranscendentPlasmaMixer> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected GT_Multiblock_Tooltip_Builder createTooltip() {
        GT_Multiblock_Tooltip_Builder tt = new GT_Multiblock_Tooltip_Builder();
        tt.addMachineType("Transcendent Mixer").addInfo("Assisting in all your DTPF needs.").addInfo("This multiblock will run in parallel according to the circuit provided to the").addInfo("controller slot. E.g. 3x Circuit #16 = 48x parallel. All inputs will scale,").addInfo("except time. All EU is deducted from wireless EU networks only.").addInfo(GT_Values.AuthorColen).addInfo("Controller slot and circuit slot are separate.").addSeparator().beginStructureBlock(5, 7, 5, false).addStructureInfo(EnumChatFormatting.GOLD + "1+ " + EnumChatFormatting.GRAY + "Input Hatch").addStructureInfo(EnumChatFormatting.GOLD + "1+ " + EnumChatFormatting.GRAY + "Output Hatch").addStructureInfo(EnumChatFormatting.GOLD + "1+ " + EnumChatFormatting.GRAY + "Input Bus").addStructureInfo(EnumChatFormatting.GOLD + "1 " + EnumChatFormatting.GRAY + "Maintenance Hatch").toolTipFinisher("Gregtech");
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_TranscendentPlasmaMixer(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection aFacing, int colorIndex, boolean aActive, boolean redstoneLevel) {
        if (side == aFacing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_DTPF_ON).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FUSION1_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_DTPF_OFF).extFacing().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][12]};
    }

    @Override
    public boolean isCorrectMachinePart(ItemStack aStack) {
        return true;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.transcendentPlasmaMixerRecipes;
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@Nonnull GT_Recipe recipe) {
                GT_MetaTileEntity_TranscendentPlasmaMixer.this.mWirelessEUt = 10L * (long)recipe.mEUt * (long)GT_MetaTileEntity_TranscendentPlasmaMixer.this.multiplier;
                if (GT_MetaTileEntity_TranscendentPlasmaMixer.this.getUserEU(GT_MetaTileEntity_TranscendentPlasmaMixer.this.ownerUUID).compareTo(BigInteger.valueOf(GT_MetaTileEntity_TranscendentPlasmaMixer.this.mWirelessEUt * (long)recipe.mDuration)) < 0) {
                    return CheckRecipeResultRegistry.insufficientPower(GT_MetaTileEntity_TranscendentPlasmaMixer.this.mWirelessEUt * (long)recipe.mDuration);
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @NotNull
            protected CheckRecipeResult onRecipeStart(@Nonnull GT_Recipe recipe) {
                GT_MetaTileEntity_TranscendentPlasmaMixer.this.mWirelessEUt = 10L * (long)recipe.mEUt * (long)GT_MetaTileEntity_TranscendentPlasmaMixer.this.multiplier;
                if (!GT_MetaTileEntity_TranscendentPlasmaMixer.this.addEUToGlobalEnergyMap(GT_MetaTileEntity_TranscendentPlasmaMixer.this.ownerUUID, -GT_MetaTileEntity_TranscendentPlasmaMixer.this.mWirelessEUt * (long)recipe.mDuration)) {
                    return CheckRecipeResultRegistry.insufficientPower(GT_MetaTileEntity_TranscendentPlasmaMixer.this.mWirelessEUt * (long)recipe.mDuration);
                }
                this.setCalculatedEut(0L);
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }

            @Override
            @Nonnull
            protected GT_OverclockCalculator createOverclockCalculator(@Nonnull GT_Recipe recipe) {
                return GT_OverclockCalculator.ofNoOverclock(recipe);
            }
        }.setMaxParallelSupplier(() -> {
            ItemStack controllerStack = this.getControllerSlot();
            if (controllerStack != null && controllerStack.func_77973_b() instanceof GT_IntegratedCircuit_Item) {
                this.multiplier = controllerStack.field_77994_a * Math.max(1, controllerStack.func_77960_j());
            }
            return this.multiplier;
        });
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(Long.MAX_VALUE);
        logic.setAvailableAmperage(1L);
        logic.setAmperageOC(false);
    }

    @Override
    protected long getActualEnergyUsage() {
        return this.mWirelessEUt;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 2, 3, 0);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivialBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 2, 3, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 2, 3, 0)) {
            return false;
        }
        return this.mMaintenanceHatches.size() == 1;
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 0;
    }

    @Override
    public int getDamageToComponent(ItemStack aStack) {
        return 0;
    }

    @Override
    public boolean explodesOnComponentBreak(ItemStack aStack) {
        return false;
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick == 1L) {
            this.ownerUUID = this.processInitialSettings(aBaseMetaTileEntity);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("eMultiplier", this.multiplier);
        super.saveNBTData(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.multiplier = aNBT.func_74762_e("eMultiplier");
        super.loadNBTData(aNBT);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }
}

