/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.long_distance;

import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.render.TextureFactory;
import gregtech.common.tileentities.machines.long_distance.GT_MetaTileEntity_LongDistancePipelineBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class GT_MetaTileEntity_LongDistancePipelineFluid
extends GT_MetaTileEntity_LongDistancePipelineBase {
    static final FluidTankInfo[] emptyTank = new FluidTankInfo[]{new FluidTankInfo(null, Integer.MAX_VALUE)};

    public GT_MetaTileEntity_LongDistancePipelineFluid(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, "Sends fluids over long distances");
    }

    public GT_MetaTileEntity_LongDistancePipelineFluid(String aName, int aTier, String aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aDescription, aTextures);
    }

    @Override
    public boolean isSameClass(GT_MetaTileEntity_LongDistancePipelineBase other) {
        return other instanceof GT_MetaTileEntity_LongDistancePipelineFluid;
    }

    @Override
    public int getPipeMeta() {
        return 0;
    }

    public IFluidHandler getTank() {
        IGregTechTileEntity tTile = this.mTarget.getBaseMetaTileEntity();
        TileEntity tankTile = tTile.getTileEntityAtSide(tTile.getBackFacing());
        if (tankTile instanceof IFluidHandler) {
            return (IFluidHandler)tankTile;
        }
        return null;
    }

    @Override
    public FluidTankInfo[] getTankInfo(ForgeDirection side) {
        IFluidHandler tankTile;
        if (this.checkTarget() && (tankTile = this.getTank()) != null) {
            return tankTile.getTankInfo(side);
        }
        return emptyTank;
    }

    @Override
    public int fill(ForgeDirection side, FluidStack aFluid, boolean aDoFill) {
        if (this.checkTarget()) {
            IGregTechTileEntity tTile = this.mTarget.getBaseMetaTileEntity();
            IFluidHandler tankTile = this.getTank();
            if (tankTile != null) {
                return tankTile.fill(tTile.getFrontFacing(), aFluid, aDoFill);
            }
        }
        return 0;
    }

    @Override
    public FluidStack drain(ForgeDirection side, FluidStack aFluid, boolean aDoDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection side, int aMaxDrain, boolean aDoDrain) {
        return null;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_LongDistancePipelineFluid(this.mName, (int)this.mTier, this.getDescription()[0], this.mTextures);
    }

    @Override
    public ITexture[] getTextureOverlays() {
        ITexture[] overlays = new ITexture[]{TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPELINE_FLUID_FRONT), TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPELINE_FLUID_BACK), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPELINE_FLUID_SIDE_UP_DOWN), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_PIPELINE_FLUID_SIDE_UP_DOWN_GLOW).glow().build()), TextureFactory.of(TextureFactory.of(Textures.BlockIcons.OVERLAY_PIPELINE_FLUID_SIDE_LEFT_RIGHT), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_PIPELINE_FLUID_SIDE_LEFT_RIGHT_GLOW).glow().build())};
        return overlays;
    }
}

