/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AECableType;
import appeng.core.stats.Stats;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.ReadableNumberConverter;
import gregtech.GT_Mod;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.GT_MetaTileEntity_Hatch_Output;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class GT_MetaTileEntity_Hatch_Output_ME
extends GT_MetaTileEntity_Hatch_Output
implements IPowerChannelState {
    private BaseActionSource requestSource = null;
    @Nullable
    private AENetworkProxy gridProxy = null;
    final IItemList<IAEFluidStack> fluidCache = AEApi.instance().storage().createFluidList();
    long lastOutputTick = 0L;
    long tickCounter = 0L;
    boolean lastOutputFailed = false;
    boolean infiniteCache = true;
    boolean additionalConnection = false;

    public GT_MetaTileEntity_Hatch_Output_ME(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 3, new String[]{"Fluid Output for Multiblocks", "Stores directly into ME", "Can cache infinite amount of fluids.", "Change cache behavior by right-clicking with screwdriver.", "Change ME connection behavior by right-clicking with wire cutter"}, 0);
    }

    public GT_MetaTileEntity_Hatch_Output_ME(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new GT_MetaTileEntity_Hatch_Output_ME(this.mName, (int)this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_FLUID_HATCH_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(Textures.BlockIcons.OVERLAY_ME_FLUID_HATCH)};
    }

    @Override
    public byte getTierForStructure() {
        return (byte)(GT_Values.V.length - 2);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    @Override
    public int fill(FluidStack aFluid, boolean doFill) {
        if (doFill) {
            return this.tryFillAE(aFluid);
        }
        if (!this.infiniteCache && this.lastOutputFailed || aFluid == null) {
            return 0;
        }
        return aFluid.amount;
    }

    public int tryFillAE(FluidStack aFluid) {
        if (!this.infiniteCache && this.lastOutputFailed || aFluid == null) {
            return 0;
        }
        this.fluidCache.add((IAEStack)AEApi.instance().storage().createFluidStack(aFluid));
        return aFluid.amount;
    }

    private BaseActionSource getRequest() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this.getBaseMetaTileEntity());
        }
        return this.requestSource;
    }

    @Override
    public AECableType getCableConnectionType(ForgeDirection side) {
        return this.isOutputFacing(side) ? AECableType.SMART : AECableType.NONE;
    }

    private void updateValidGridProxySides() {
        if (this.additionalConnection) {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN)));
        } else {
            this.getProxy().setValidSides(EnumSet.of(this.getBaseMetaTileEntity().getFrontFacing()));
        }
    }

    @Override
    public void onFacingChange() {
        this.updateValidGridProxySides();
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        return false;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean doesFillContainers() {
        return false;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        if (!this.getBaseMetaTileEntity().getCoverInfoAtSide(side).isGUIClickable()) {
            return;
        }
        this.infiniteCache = !this.infiniteCache;
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.hatch.infiniteCacheFluid." + this.infiniteCache, new Object[0]));
    }

    @Override
    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        this.additionalConnection = !this.additionalConnection;
        this.updateValidGridProxySides();
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.hatch.additionalConnection." + this.additionalConnection, new Object[0]));
        return true;
    }

    @Override
    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this.getBaseMetaTileEntity(), "proxy", ItemList.Hatch_Output_ME.get(1L, new Object[0]), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.updateValidGridProxySides();
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    private void flushCachedStack() {
        if (this.fluidCache.isEmpty()) {
            return;
        }
        this.lastOutputFailed = true;
        AENetworkProxy proxy = this.getProxy();
        if (proxy == null) {
            this.lastOutputFailed = true;
            return;
        }
        try {
            IMEMonitor sg = proxy.getStorage().getFluidInventory();
            for (IAEFluidStack s : this.fluidCache) {
                if (s.getStackSize() == 0L) continue;
                IAEFluidStack rest = GT_MetaTileEntity_Hatch_Output_ME.fluidAEInsert((IEnergySource)proxy.getEnergy(), (IMEInventory<IAEFluidStack>)sg, s, this.getRequest());
                if (rest != null && rest.getStackSize() > 0L) {
                    s.setStackSize(rest.getStackSize());
                    continue;
                }
                this.lastOutputFailed = false;
                s.setStackSize(0L);
            }
        }
        catch (GridAccessException ignored) {
            this.lastOutputFailed = true;
        }
        this.lastOutputTick = this.tickCounter;
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            this.tickCounter = aTick;
            if (this.tickCounter > this.lastOutputTick + 40L) {
                this.flushCachedStack();
            }
            if (this.tickCounter % 20L == 0L) {
                this.getBaseMetaTileEntity().setActive(this.isActive());
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        NBTTagList fluids = new NBTTagList();
        for (IAEFluidStack s : this.fluidCache) {
            if (s.getStackSize() == 0L) continue;
            NBTTagCompound tag = new NBTTagCompound();
            NBTTagCompound tagFluidStack = new NBTTagCompound();
            s.getFluidStack().writeToNBT(tagFluidStack);
            tag.func_74782_a("fluidStack", (NBTBase)tagFluidStack);
            tag.func_74772_a("size", s.getStackSize());
            fluids.func_74742_a((NBTBase)tag);
        }
        aNBT.func_74782_a("cachedFluids", (NBTBase)fluids);
        aNBT.func_74757_a("infiniteCache", this.infiniteCache);
        aNBT.func_74757_a("additionalConnection", this.additionalConnection);
        this.getProxy().writeToNBT(aNBT);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        NBTBase t = aNBT.func_74781_a("cachedFluids");
        if (t instanceof NBTTagList) {
            NBTTagList l = (NBTTagList)t;
            for (int i = 0; i < l.func_74745_c(); ++i) {
                NBTTagCompound tag = l.func_150305_b(i);
                NBTTagCompound tagFluidStack = tag.func_74775_l("fluidStack");
                IAEFluidStack s = AEApi.instance().storage().createFluidStack(GT_Utility.loadFluid(tagFluidStack));
                if (s != null) {
                    s.setStackSize(tag.func_74763_f("size"));
                    this.fluidCache.add((IAEStack)s);
                    continue;
                }
                GT_Mod.GT_FML_LOGGER.warn("An error occurred while loading contents of ME Output Hatch. This fluid has been voided: " + tagFluidStack);
            }
        }
        if (aNBT.func_74764_b("infiniteCache")) {
            this.infiniteCache = aNBT.func_74767_n("infiniteCache");
        }
        this.additionalConnection = aNBT.func_74767_n("additionalConnection");
        this.getProxy().readFromNBT(aNBT);
    }

    public boolean isLastOutputFailed() {
        return this.lastOutputFailed;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> ss = new ArrayList<String>();
        ss.add("The hatch is " + (this.getProxy() != null && this.getProxy().isActive() ? EnumChatFormatting.GREEN + "online" : EnumChatFormatting.RED + "offline" + this.getAEDiagnostics()) + EnumChatFormatting.RESET);
        if (this.fluidCache.isEmpty()) {
            ss.add("The bus has no cached fluids");
        } else {
            ReadableNumberConverter nc = ReadableNumberConverter.INSTANCE;
            ss.add(String.format("The hatch contains %d cached fluids: ", this.fluidCache.size()));
            int counter = 0;
            for (IAEFluidStack s : this.fluidCache) {
                ss.add(s.getFluidStack().getLocalizedName() + ": " + EnumChatFormatting.GOLD + nc.toWideReadableForm(s.getStackSize()) + " mB" + EnumChatFormatting.RESET);
                if (++counter <= 100) continue;
                break;
            }
        }
        return ss.toArray(new String[this.fluidCache.size() + 2]);
    }

    public static IAEFluidStack fluidAEInsert(IEnergySource energy, IMEInventory<IAEFluidStack> cell, IAEFluidStack input, BaseActionSource src) {
        long power;
        double availablePower;
        long itemToAdd;
        IAEFluidStack possible = (IAEFluidStack)cell.injectItems((IAEStack)input.copy(), Actionable.SIMULATE, src);
        long stored = input.getStackSize();
        if (possible != null) {
            stored -= possible.getStackSize();
        }
        if ((itemToAdd = Math.min((long)((availablePower = energy.extractAEPower((double)(power = Math.max(1L, stored / 1000L)), Actionable.SIMULATE, PowerMultiplier.CONFIG)) + 0.9) * 1000L, stored)) > 0L) {
            energy.extractAEPower((double)power, Actionable.MODULATE, PowerMultiplier.CONFIG);
            if (itemToAdd < input.getStackSize()) {
                long original = input.getStackSize();
                IAEFluidStack split = input.copy();
                split.decStackSize(itemToAdd);
                input.setStackSize(itemToAdd);
                split.add((IAEFluidStack)cell.injectItems((IAEStack)input, Actionable.MODULATE, src));
                if (src.isPlayer()) {
                    long diff = original - split.getStackSize();
                    Stats.ItemsInserted.addToPlayer(((PlayerSource)src).player, (int)diff);
                }
                return split;
            }
            IAEFluidStack ret = (IAEFluidStack)cell.injectItems((IAEStack)input, Actionable.MODULATE, src);
            if (src.isPlayer()) {
                long diff = ret == null ? input.getStackSize() : input.getStackSize() - ret.getStackSize();
                Stats.ItemsInserted.addToPlayer(((PlayerSource)src).player, (int)diff);
            }
            return ret;
        }
        return input;
    }
}

