/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import codechicken.lib.render.TextureUtils;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.api.util.GT_Utility;
import gregtech.common.render.items.GT_GeneratedMaterial_Renderer;
import java.util.Random;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class InfinityRenderer
extends GT_GeneratedMaterial_Renderer {
    public Random rand = new Random();

    @Override
    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        short aMetaData = (short)aStack.func_77960_j();
        Item item = aStack.func_77973_b();
        if (!(item instanceof IGT_ItemWithMaterialRenderer)) {
            return;
        }
        IGT_ItemWithMaterialRenderer aItem = (IGT_ItemWithMaterialRenderer)item;
        int passes = 1;
        if (aItem.requiresMultipleRenderPasses()) {
            passes = aItem.getRenderPasses(aMetaData);
        }
        for (int pass = 0; pass < passes; ++pass) {
            IIcon fluidIcon;
            IIcon tIcon = aItem.getIcon(aMetaData, pass);
            IIcon tOverlay = aItem.getOverlayIcon(aMetaData, pass);
            FluidStack aFluid = GT_Utility.getFluidForFilledItem(aStack, true);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)3008);
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                if (pass == 0) {
                    this.renderHalo();
                }
                this.renderPulse(tOverlay, tIcon);
            }
            if (passes == 1) {
                GL11.glEnable((int)2929);
            }
            GL11.glEnable((int)3008);
            if (tIcon != null) {
                this.markNeedsAnimationUpdate(tIcon);
                this.renderRegularItem(type, aStack, tIcon, aFluid == null);
            }
            if (tOverlay != null && aFluid != null && aFluid.getFluid() != null && (fluidIcon = aFluid.getFluid().getIcon(aFluid)) != null) {
                this.markNeedsAnimationUpdate(fluidIcon);
                this.renderContainedFluid(type, aFluid, fluidIcon);
            }
            if (tOverlay != null) {
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                TextureUtils.bindAtlas((int)aItem.getSpriteNumber());
                this.markNeedsAnimationUpdate(tOverlay);
                this.renderItemOverlay(type, tOverlay);
            }
            GL11.glDisable((int)3042);
        }
    }

    private void renderHalo() {
        GL11.glPushMatrix();
        IIcon halo = Textures.ItemIcons.HALO.getIcon();
        int spread = 10;
        int haloAlpha = -16777216;
        if (halo == null) {
            return;
        }
        Tessellator t = Tessellator.field_78398_a;
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3008);
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)0.078431375f, (float)0.078431375f, (float)0.078431375f, (float)((float)(haloAlpha >> 24 & 0xFF) / 255.0f));
        t.func_78382_b();
        t.func_78374_a((double)(-spread), (double)(-spread), 0.0, (double)halo.func_94209_e(), (double)halo.func_94206_g());
        t.func_78374_a((double)(-spread), (double)(16 + spread), 0.0, (double)halo.func_94209_e(), (double)halo.func_94210_h());
        t.func_78374_a((double)(16 + spread), (double)(16 + spread), 0.0, (double)halo.func_94212_f(), (double)halo.func_94210_h());
        t.func_78374_a((double)(16 + spread), (double)(-spread), 0.0, (double)halo.func_94212_f(), (double)halo.func_94206_g());
        t.func_78381_a();
        GL11.glPopMatrix();
    }

    private void renderPulse(IIcon ... icons) {
        Tessellator t = Tessellator.field_78398_a;
        double random = this.rand.nextGaussian();
        double scale = random * 0.15 + 0.95;
        double offset = (1.0 - scale) / 2.0;
        for (IIcon icon : icons) {
            if (icon == null) continue;
            GL11.glPushMatrix();
            GL11.glEnable((int)3042);
            GL11.glTranslated((double)(offset * 16.0), (double)(offset * 16.0), (double)1.0);
            GL11.glScaled((double)scale, (double)scale, (double)1.0);
            t.func_78382_b();
            t.func_78369_a(1.0f, 1.0f, 1.0f, 0.6f);
            t.func_78374_a(0.0 - offset, 0.0 - offset, 0.0, (double)icon.func_94209_e(), (double)icon.func_94206_g());
            t.func_78374_a(0.0 - offset, 16.0 + offset, 0.0, (double)icon.func_94209_e(), (double)icon.func_94210_h());
            t.func_78374_a(16.0 + offset, 16.0 + offset, 0.0, (double)icon.func_94212_f(), (double)icon.func_94210_h());
            t.func_78374_a(16.0 + offset, 0.0 - offset, 0.0, (double)icon.func_94212_f(), (double)icon.func_94206_g());
            t.func_78381_a();
            GL11.glPopMatrix();
        }
    }
}

