/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import gregtech.api.enums.GT_Values;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.TierEU;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.items.PropolisType;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.fluids.FluidRegistry;

public class ItemPropolis
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon secondIcon;

    public ItemPropolis() {
        this.func_77637_a(Tabs.tabApiculture);
        this.func_77627_a(true);
        this.func_77655_b("gt.propolis");
        GameRegistry.registerItem((Item)this, (String)"gt.propolis", (String)Mods.GregTech.ID);
    }

    public ItemStack getStackForType(PropolisType type) {
        return new ItemStack((Item)this, 1, type.ordinal());
    }

    public ItemStack getStackForType(PropolisType type, int count) {
        return new ItemStack((Item)this, count, type.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List<ItemStack> list) {
        for (PropolisType type : PropolisType.values()) {
            if (!type.showInList) continue;
            list.add(this.getStackForType(type));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("forestry:propolis.0");
    }

    public IIcon getIcon(ItemStack stack, int pass) {
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        int meta = Math.max(0, Math.min(PropolisType.values().length - 1, stack.func_77960_j()));
        return PropolisType.values()[meta].getColours();
    }

    public String func_77653_i(ItemStack stack) {
        return PropolisType.values()[stack.func_77960_j()].getName();
    }

    public void initPropolisRecipes() {
        ItemStack tPropolis = this.getStackForType(PropolisType.End);
        this.addProcessHV(tPropolis, GT_ModHandler.getModItem(Mods.HardcoreEnderExpansion.ID, "end_powder", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Stardust);
        this.addProcessHV(tPropolis, GT_ModHandler.getModItem(Mods.HardcoreEnderExpansion.ID, "stardust", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Ectoplasma);
        this.addProcessEV(tPropolis, GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.EctoplasmaChip", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Arcaneshard);
        this.addProcessEV(tPropolis, GT_ModHandler.getModItem(Mods.NewHorizonsCoreMod.ID, "item.ArcaneShardChip", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Dragonessence);
        this.addProcessIV(tPropolis, GT_ModHandler.getModItem(Mods.HardcoreEnderExpansion.ID, "essence", 16L, 0));
        tPropolis = this.getStackForType(PropolisType.Enderman);
        this.addProcessIV(tPropolis, GT_ModHandler.getModItem(Mods.HardcoreEnderExpansion.ID, "enderman_head", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Silverfish);
        this.addProcessEV(tPropolis, GT_ModHandler.getModItem(Mods.HardcoreEnderExpansion.ID, "silverfish_blood", 1L, 0));
        tPropolis = this.getStackForType(PropolisType.Endium);
        this.addProcessHV(tPropolis, GT_OreDictUnificator.get(OrePrefixes.dustSmall, Materials.HeeEndium, 1L));
        tPropolis = this.getStackForType(PropolisType.Fireessence);
        this.addProcessIV(tPropolis, GT_ModHandler.getModItem(Mods.HardcoreEnderExpansion.ID, "essence", 16L, 1));
    }

    public void addProcessHV(ItemStack tPropolis, ItemStack aOutput2) {
        GT_Values.RA.stdBuilder().itemInputs(tPropolis).itemOutputs(aOutput2).outputChances(5000).fluidOutputs(FluidRegistry.getFluidStack((String)"endergoo", (int)100)).duration(50).eut(TierEU.RECIPE_HV).addTo(RecipeMaps.fluidExtractionRecipes);
    }

    public void addProcessEV(ItemStack tPropolis, ItemStack aOutput2) {
        GT_Values.RA.stdBuilder().itemInputs(tPropolis).itemOutputs(aOutput2).outputChances(2500).fluidOutputs(FluidRegistry.getFluidStack((String)"endergoo", (int)200)).duration(100).eut(TierEU.RECIPE_EV).addTo(RecipeMaps.fluidExtractionRecipes);
    }

    public void addProcessIV(ItemStack tPropolis, ItemStack aOutput2) {
        GT_Values.RA.stdBuilder().itemInputs(tPropolis).itemOutputs(aOutput2).outputChances(1500).fluidOutputs(FluidRegistry.getFluidStack((String)"endergoo", (int)300)).duration(150).eut(TierEU.RECIPE_IV).addTo(RecipeMaps.fluidExtractionRecipes);
    }
}

