/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects.overclockdescriber;

import gregtech.api.objects.overclockdescriber.OverclockDescriber;
import gregtech.api.util.GT_OverclockCalculator;
import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_Utility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class EUNoOverclockDescriber
extends OverclockDescriber {
    protected final int amperage;

    public EUNoOverclockDescriber(byte tier, int amperage) {
        super(tier);
        if (amperage < 1) {
            throw new IllegalArgumentException("Amperage cannot be lower than 1");
        }
        this.amperage = amperage;
    }

    @Override
    public GT_OverclockCalculator createCalculator(GT_OverclockCalculator template, GT_Recipe recipe) {
        return GT_OverclockCalculator.ofNoOverclock(recipe);
    }

    @Override
    public String getTierString() {
        return GT_Utility.getColoredTierNameFromTier(this.tier);
    }

    @Override
    public final void drawEnergyInfo(RecipeDisplayInfo recipeInfo) {
        if (recipeInfo.calculator.getDuration() > 0 && recipeInfo.calculator.getConsumption() > 0L) {
            recipeInfo.drawText(GT_Utility.trans("152", "Total: ") + this.getTotalPowerString(recipeInfo.calculator));
        }
        this.drawEnergyInfoImpl(recipeInfo);
    }

    protected void drawEnergyInfoImpl(RecipeDisplayInfo recipeInfo) {
        if (recipeInfo.calculator.getConsumption() <= 0L) {
            return;
        }
        recipeInfo.drawText(GT_Utility.trans("153", "Usage: ") + this.getEUtDisplay(recipeInfo.calculator));
        if (this.shouldShowAmperage(recipeInfo.calculator)) {
            recipeInfo.drawText(GT_Utility.trans("154", "Voltage: ") + this.getVoltageString(recipeInfo.calculator));
            recipeInfo.drawText(GT_Utility.trans("155", "Amperage: ") + this.getAmperageString(recipeInfo.calculator));
        }
    }

    protected String getTotalPowerString(GT_OverclockCalculator calculator) {
        return GT_Utility.formatNumbers(calculator.getConsumption() * (long)calculator.getDuration()) + " EU";
    }

    protected boolean shouldShowAmperage(GT_OverclockCalculator calculator) {
        return this.amperage != 1;
    }

    protected String getEUtWithoutTier(GT_OverclockCalculator calculator) {
        return GT_Utility.formatNumbers(calculator.getConsumption()) + " EU/t";
    }

    protected String getEUtWithTier(GT_OverclockCalculator calculator) {
        return this.getEUtWithoutTier(calculator) + GT_Utility.getTierNameWithParentheses(calculator.getConsumption());
    }

    protected String getEUtDisplay(GT_OverclockCalculator calculator) {
        return this.shouldShowAmperage(calculator) ? this.getEUtWithoutTier(calculator) : this.getEUtWithTier(calculator);
    }

    protected String getVoltageString(GT_OverclockCalculator calculator) {
        long voltage = this.computeVoltageForEURate(calculator.getConsumption());
        return GT_Utility.formatNumbers(voltage) + " EU/t" + GT_Utility.getTierNameWithParentheses(voltage);
    }

    protected String getAmperageString(GT_OverclockCalculator calculator) {
        return GT_Utility.formatNumbers(this.amperage);
    }

    protected long computeVoltageForEURate(long euPerTick) {
        return euPerTick / (long)this.amperage;
    }
}

