/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.objects;

import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;

public class GT_ArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 1L;
    private int size_sS;
    private final boolean mAllowNulls;

    public GT_ArrayList(boolean aAllowNulls, int aCapacity) {
        super(aCapacity);
        this.mAllowNulls = aAllowNulls;
    }

    @SafeVarargs
    public GT_ArrayList(boolean aAllowNulls, E ... aArray) {
        super(Arrays.asList(aArray));
        this.mAllowNulls = aAllowNulls;
        if (!this.mAllowNulls) {
            this.size_sS = this.size();
            for (int i = 0; i < this.size_sS; ++i) {
                if (this.get(i) != null) continue;
                this.remove(i--);
                this.size_sS = this.size();
            }
        }
    }

    public GT_ArrayList(boolean aAllowNulls, Collection<? extends E> aList) {
        super(aList);
        this.mAllowNulls = aAllowNulls;
        if (!this.mAllowNulls) {
            this.size_sS = this.size();
            for (int i = 0; i < this.size_sS; ++i) {
                if (this.get(i) != null) continue;
                this.remove(i--);
                this.size_sS = this.size();
            }
        }
    }

    @Override
    public E set(int aIndex, E aElement) {
        if (this.mAllowNulls || aElement != null) {
            return super.set(aIndex, aElement);
        }
        return null;
    }

    @Override
    public boolean add(E aElement) {
        if (this.mAllowNulls || aElement != null) {
            return super.add(aElement);
        }
        return false;
    }

    @Override
    public void add(int aIndex, E aElement) {
        if (this.mAllowNulls || aElement != null) {
            super.add(aIndex, aElement);
        }
    }

    @Override
    public boolean addAll(Collection<? extends E> aList) {
        return super.addAll(Collections2.filter(aList, Objects::nonNull));
    }

    @Override
    public boolean addAll(int aIndex, Collection<? extends E> aList) {
        return super.addAll(aIndex, Collections2.filter(aList, Objects::nonNull));
    }
}

