/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import gregtech.api.util.GT_Recipe;
import gregtech.api.util.GT_RecipeBuilder;
import gregtech.api.util.GT_Utility;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;

public interface IRecipeMap {
    public void addDownstream(IRecipeMap var1);

    @Nonnull
    public Collection<GT_Recipe> doAdd(GT_RecipeBuilder var1);

    default public IRecipeMap deepCopyInput() {
        return IRecipeMap.newRecipeMap(b -> this.doAdd(b.copy()));
    }

    public static IRecipeMap newRecipeMap(final Function<? super GT_RecipeBuilder, Collection<GT_Recipe>> func) {
        return new IRecipeMap(){
            private final Collection<IRecipeMap> downstreams = new ArrayList<IRecipeMap>();

            @Override
            public void addDownstream(IRecipeMap downstream) {
                this.downstreams.add(downstream);
            }

            @Override
            @Nonnull
            public Collection<GT_Recipe> doAdd(GT_RecipeBuilder builder) {
                ArrayList<Collection<Collection<GT_Recipe>>> ret = new ArrayList<Collection<Collection<GT_Recipe>>>();
                Collection out = (Collection)func.apply(builder);
                ret.add(out);
                builder.clearInvalid();
                if (!out.isEmpty()) {
                    for (IRecipeMap downstream : this.downstreams) {
                        ret.add(downstream.doAdd(builder));
                    }
                }
                return GT_Utility.concat(ret);
            }
        };
    }
}

