/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.hydroenergy.server;

import com.sinthoras.hydroenergy.HE;
import com.sinthoras.hydroenergy.HEUtil;
import com.sinthoras.hydroenergy.blocks.HEWater;
import com.sinthoras.hydroenergy.config.HEConfig;
import com.sinthoras.hydroenergy.network.packet.HEPacketChunkUpdate;
import com.sinthoras.hydroenergy.server.HEServer;
import com.sinthoras.hydroenergy.server.QueueEntry;
import com.sinthoras.hydroenergy.server.mytown2.HEMyTown2Integration;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.NibbleArray;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;

class HEQueueChunk {
    public Stack<QueueEntry> blockStack;
    public Stack<QueueEntry> neighborChunkWest = new Stack();
    public Stack<QueueEntry> neighborChunkNorth = new Stack();
    public Stack<QueueEntry> neighborChunkEast = new Stack();
    public Stack<QueueEntry> neighborChunkSouth = new Stack();
    public Chunk chunk;

    HEQueueChunk(Chunk chunk, Stack<QueueEntry> blockStack) {
        this.chunk = chunk;
        this.blockStack = blockStack;
    }

    HEQueueChunk(Chunk chunk, HEWater waterBlock, int blockX, int blockY, int blockZ) {
        this.chunk = chunk;
        this.blockStack = new Stack();
        this.blockStack.add(new QueueEntry(blockX, blockY, blockZ, waterBlock));
    }

    public boolean resolve() {
        boolean changedChunk;
        boolean[] permissionsChecked = new boolean[HEConfig.maxDams];
        boolean[] hasPermissions = new boolean[HEConfig.maxDams];
        ExtendedBlockStorage[] chunkStorage = this.chunk.func_76587_i();
        short subChunksHaveChanges = 0;
        while (!this.blockStack.isEmpty()) {
            int chunkY;
            boolean removeBlock;
            QueueEntry entry = this.blockStack.pop();
            int waterId = entry.waterBlock.getWaterId();
            if (!permissionsChecked[waterId]) {
                hasPermissions[waterId] = HEMyTown2Integration.getInstance().hasPlayerModificationRightsForChunk(HEServer.instance.getOwnerName(waterId), this.chunk.field_76637_e.field_73011_w.field_76574_g, this.chunk.field_76635_g, this.chunk.field_76647_h);
                permissionsChecked[waterId] = true;
            }
            Block block = this.chunk.func_150810_a(entry.blockX & 0xF, entry.blockY, entry.blockZ & 0xF);
            boolean bl = removeBlock = !HEServer.instance.canSpread(waterId) || HEServer.instance.isBlockOutOfBounds(waterId, entry.blockX, entry.blockY, entry.blockZ) || !hasPermissions[waterId];
            if (removeBlock) {
                if (block != entry.waterBlock) continue;
                chunkY = entry.blockY >> 4;
                chunkStorage[chunkY].func_150818_a(entry.blockX & 0xF, entry.blockY & 0xF, entry.blockZ & 0xF, Blocks.field_150350_a);
                HEServer.instance.onWaterRemoved(waterId, entry.blockY);
                subChunksHaveChanges = (short)(subChunksHaveChanges | HEUtil.chunkYToFlag(chunkY));
                this.add(entry.blockX - 1, entry.blockY, entry.blockZ, entry.waterBlock);
                this.add(entry.blockX, entry.blockY - 1, entry.blockZ, entry.waterBlock);
                this.add(entry.blockX, entry.blockY, entry.blockZ - 1, entry.waterBlock);
                this.add(entry.blockX + 1, entry.blockY, entry.blockZ, entry.waterBlock);
                this.add(entry.blockX, entry.blockY + 1, entry.blockZ, entry.waterBlock);
                this.add(entry.blockX, entry.blockY, entry.blockZ + 1, entry.waterBlock);
                continue;
            }
            if (!entry.waterBlock.canFlowInto((IBlockAccess)this.chunk.field_76637_e, entry.blockX, entry.blockY, entry.blockZ)) continue;
            chunkY = entry.blockY >> 4;
            if (chunkStorage[chunkY] == null) {
                chunkStorage[chunkY] = new ExtendedBlockStorage(chunkY << 4, !this.chunk.field_76637_e.field_73011_w.field_76576_e);
            }
            chunkStorage[chunkY].func_150818_a(entry.blockX & 0xF, entry.blockY & 0xF, entry.blockZ & 0xF, (Block)entry.waterBlock);
            if (this.chunk.func_76619_d(entry.blockX & 0xF, entry.blockY, entry.blockZ & 0xF)) {
                chunkStorage[chunkY].func_76671_l().func_76581_a(entry.blockX & 0xF, entry.blockY & 0xF, entry.blockZ & 0xF, 15);
            } else {
                NibbleArray skylightArray;
                int highestOpaqueBlockY = this.chunk.field_76634_f[(entry.blockZ & 0xF) << 4 | entry.blockX & 0xF];
                int highestOpaqueChunkY = HEUtil.coordBlockToChunk(highestOpaqueBlockY);
                if (chunkStorage[highestOpaqueChunkY] == null) {
                    chunkStorage[highestOpaqueChunkY] = new ExtendedBlockStorage(highestOpaqueChunkY << 4, !this.chunk.field_76637_e.field_73011_w.field_76576_e);
                }
                if ((skylightArray = chunkStorage[highestOpaqueChunkY].func_76671_l()) == null) {
                    skylightArray = new NibbleArray(4096, 4);
                    chunkStorage[highestOpaqueChunkY].func_76666_d(skylightArray);
                }
                int lightValue = skylightArray.func_76582_a(entry.blockZ & 0xF, highestOpaqueBlockY & 0xF, entry.blockX & 0xF);
                skylightArray.func_76581_a(entry.blockX & 0xF, entry.blockY & 0xF, entry.blockZ & 0xF, lightValue);
            }
            HEServer.instance.onWaterPlaced(waterId, entry.blockY);
            subChunksHaveChanges = (short)(subChunksHaveChanges | HEUtil.chunkYToFlag(chunkY));
            this.add(entry.blockX - 1, entry.blockY, entry.blockZ, entry.waterBlock);
            this.add(entry.blockX, entry.blockY - 1, entry.blockZ, entry.waterBlock);
            this.add(entry.blockX, entry.blockY, entry.blockZ - 1, entry.waterBlock);
            this.add(entry.blockX + 1, entry.blockY, entry.blockZ, entry.waterBlock);
            this.add(entry.blockX, entry.blockY + 1, entry.blockZ, entry.waterBlock);
            this.add(entry.blockX, entry.blockY, entry.blockZ + 1, entry.waterBlock);
        }
        boolean bl = changedChunk = subChunksHaveChanges > 0;
        if (changedChunk) {
            this.chunk.func_76630_e();
            HEPacketChunkUpdate message = new HEPacketChunkUpdate(this.chunk, subChunksHaveChanges);
            for (EntityPlayerMP player : MinecraftServer.func_71276_C().func_71203_ab().field_72404_b) {
                if (this.chunk.field_76637_e.field_73011_w.field_76574_g != player.field_70170_p.field_73011_w.field_76574_g || !player.func_71121_q().func_73040_p().func_72694_a(player, this.chunk.field_76635_g, this.chunk.field_76647_h)) continue;
                HE.network.sendTo((IMessage)message, player);
            }
        }
        return changedChunk;
    }

    public void add(int blockX, int blockY, int blockZ, HEWater waterBlock) {
        QueueEntry entry = new QueueEntry(blockX, blockY, blockZ, waterBlock);
        int chunkX = HEUtil.coordBlockToChunk(blockX);
        int chunkZ = HEUtil.coordBlockToChunk(blockZ);
        Block block = this.chunk.func_150810_a(blockX & 0xF, blockY, blockZ & 0xF);
        if (chunkX < this.chunk.field_76635_g) {
            this.neighborChunkWest.push(entry);
        } else if (chunkZ < this.chunk.field_76647_h) {
            this.neighborChunkNorth.push(entry);
        } else if (chunkX > this.chunk.field_76635_g) {
            this.neighborChunkEast.push(entry);
        } else if (chunkZ > this.chunk.field_76647_h) {
            this.neighborChunkSouth.push(entry);
        } else if (block == waterBlock || waterBlock.canFlowInto((IBlockAccess)this.chunk.field_76637_e, blockX, blockY, blockZ)) {
            this.blockStack.push(entry);
        }
    }

    public boolean isLoaded() {
        IChunkProvider chunkProvider = this.chunk.field_76637_e.func_72863_F();
        return chunkProvider.func_73149_a(this.chunk.field_76635_g, this.chunk.field_76647_h) && chunkProvider.func_73149_a(this.chunk.field_76635_g - 1, this.chunk.field_76647_h) && chunkProvider.func_73149_a(this.chunk.field_76635_g, this.chunk.field_76647_h - 1) && chunkProvider.func_73149_a(this.chunk.field_76635_g + 1, this.chunk.field_76647_h) && chunkProvider.func_73149_a(this.chunk.field_76635_g, this.chunk.field_76647_h + 1);
    }
}

