/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.block.IMassiveBlock;
import de.katzenpapst.amunra.tile.TileEntityARChest;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.items.ItemBlockDesc;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockARChest
extends BlockContainer
implements ITileEntityProvider,
ItemBlockDesc.IBlockShiftDesc,
IMassiveBlock {
    protected final Random random = new Random();
    protected float mass = 1.0f;
    protected final ResourceLocation smallChestTexture;
    protected final ResourceLocation bigChestTexture;
    protected final String fallbackTexture;
    protected boolean canDoublechest = true;
    protected String shiftDescription = null;

    public BlockARChest(Material material, String blockName, ResourceLocation smallChestTexture, ResourceLocation bigChestTexture, String fallbackTexture) {
        super(material);
        this.func_149711_c(2.5f);
        this.func_149752_b(100.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c(blockName);
        this.smallChestTexture = smallChestTexture;
        this.bigChestTexture = bigChestTexture;
        this.fallbackTexture = fallbackTexture;
    }

    public BlockARChest(Material material, String blockName, ResourceLocation smallChestTexture, String fallbackTexture) {
        super(material);
        this.func_149711_c(2.5f);
        this.func_149752_b(100.0f);
        this.func_149672_a(Block.field_149769_e);
        this.func_149663_c(blockName);
        this.smallChestTexture = smallChestTexture;
        this.bigChestTexture = null;
        this.fallbackTexture = fallbackTexture;
    }

    public ResourceLocation getSmallTexture() {
        return this.smallChestTexture;
    }

    public ResourceLocation getLargeTexture() {
        return this.bigChestTexture;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister reg) {
        this.field_149761_L = reg.func_94245_a(this.fallbackTexture);
    }

    public void setShiftDescription(String str) {
        this.shiftDescription = str;
    }

    public String getShiftDescription(int meta) {
        if (this.shiftDescription != null) {
            return GCCoreUtil.translate((String)this.shiftDescription);
        }
        return null;
    }

    public boolean showDescription(int meta) {
        return this.shiftDescription != null;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityARChest();
    }

    @SideOnly(value=Side.CLIENT)
    public CreativeTabs func_149708_J() {
        return AmunRa.arTab;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return AmunRa.chestRenderId;
    }

    public void func_149719_a(IBlockAccess worldIn, int x, int y, int z) {
        if (!this.canDoublechest) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
            return;
        }
        if (this.isSameBlock(worldIn, x, y, z - 1)) {
            this.func_149676_a(0.0625f, 0.0f, 0.0f, 0.9375f, 0.875f, 0.9375f);
        } else if (this.isSameBlock(worldIn, x, y, z + 1)) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 1.0f);
        } else if (this.isSameBlock(worldIn, x - 1, y, z)) {
            this.func_149676_a(0.0f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        } else if (this.isSameBlock(worldIn, x + 1, y, z)) {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 1.0f, 0.875f, 0.9375f);
        } else {
            this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 0.875f, 0.9375f);
        }
    }

    public void func_149726_b(World worldIn, int x, int y, int z) {
        super.func_149726_b(worldIn, x, y, z);
        if (!this.canDoublechest) {
            return;
        }
        this.unifyAdjacentChests(worldIn, x, y, z);
        if (this.isSameBlock((IBlockAccess)worldIn, x, y, z - 1)) {
            this.unifyAdjacentChests(worldIn, x, y, z - 1);
        } else if (this.isSameBlock((IBlockAccess)worldIn, x, y, z + 1)) {
            this.unifyAdjacentChests(worldIn, x, y, z + 1);
        } else if (this.isSameBlock((IBlockAccess)worldIn, x - 1, y, z)) {
            this.unifyAdjacentChests(worldIn, x - 1, y, z);
        } else if (this.isSameBlock((IBlockAccess)worldIn, x + 1, y, z)) {
            this.unifyAdjacentChests(worldIn, x + 1, y, z);
        }
    }

    public void func_149689_a(World worldIn, int x, int y, int z, EntityLivingBase placer, ItemStack itemIn) {
        int meta;
        int userRotation = MathHelper.func_76128_c((double)((double)(placer.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (userRotation) {
            case 0: {
                int n = 2;
                break;
            }
            case 1: {
                int n = 5;
                break;
            }
            case 2: {
                int n = 3;
                break;
            }
            case 3: {
                int n = 4;
                break;
            }
            default: {
                int n = meta = 0;
            }
        }
        if (!this.canDoublechest) {
            worldIn.func_72921_c(x, y, z, meta, 3);
            return;
        }
        boolean zNegSame = this.isSameBlock((IBlockAccess)worldIn, x, y, z - 1);
        boolean zPosSame = this.isSameBlock((IBlockAccess)worldIn, x, y, z + 1);
        boolean xNegSame = this.isSameBlock((IBlockAccess)worldIn, x - 1, y, z);
        boolean xPosSame = this.isSameBlock((IBlockAccess)worldIn, x + 1, y, z);
        if (!(zNegSame || zPosSame || xNegSame || xPosSame)) {
            worldIn.func_72921_c(x, y, z, meta, 3);
        } else {
            if ((zNegSame || zPosSame) && (meta == 4 || meta == 5)) {
                if (zNegSame) {
                    worldIn.func_72921_c(x, y, z - 1, meta, 3);
                } else {
                    worldIn.func_72921_c(x, y, z + 1, meta, 3);
                }
                worldIn.func_72921_c(x, y, z, meta, 3);
            }
            if ((xNegSame || xPosSame) && (meta == 2 || meta == 3)) {
                if (xNegSame) {
                    worldIn.func_72921_c(x - 1, y, z, meta, 3);
                } else {
                    worldIn.func_72921_c(x + 1, y, z, meta, 3);
                }
                worldIn.func_72921_c(x, y, z, meta, 3);
            }
        }
    }

    public void unifyAdjacentChests(World world, int x, int y, int z) {
        int meta;
        if (!this.canDoublechest || world.field_72995_K) {
            return;
        }
        boolean zNegSame = this.isSameBlock((IBlockAccess)world, x, y, z - 1);
        boolean zPosSame = this.isSameBlock((IBlockAccess)world, x, y, z + 1);
        boolean xNegSame = this.isSameBlock((IBlockAccess)world, x - 1, y, z);
        boolean xPosSame = this.isSameBlock((IBlockAccess)world, x + 1, y, z);
        Block nZNeg = world.func_147439_a(x, y, z - 1);
        Block nZPos = world.func_147439_a(x, y, z + 1);
        Block nXNeg = world.func_147439_a(x - 1, y, z);
        Block nXPos = world.func_147439_a(x + 1, y, z);
        if (!zNegSame && !zPosSame) {
            if (!xNegSame && !xPosSame) {
                meta = 3;
                if (nZNeg.func_149730_j() && !nZPos.func_149730_j()) {
                    meta = 3;
                }
                if (nZPos.func_149730_j() && !nZNeg.func_149730_j()) {
                    meta = 2;
                }
                if (nXNeg.func_149730_j() && !nXPos.func_149730_j()) {
                    meta = 5;
                }
                if (nXPos.func_149730_j() && !nXNeg.func_149730_j()) {
                    meta = 4;
                }
            } else {
                Block otherNeighbour1 = world.func_147439_a(xNegSame ? x - 1 : x + 1, y, z - 1);
                Block otherNeighbour2 = world.func_147439_a(xNegSame ? x - 1 : x + 1, y, z + 1);
                meta = 3;
                int otherMeta = xNegSame ? world.func_72805_g(x - 1, y, z) : world.func_72805_g(x + 1, y, z);
                if (otherMeta == 2) {
                    meta = 2;
                }
                if ((nZNeg.func_149730_j() || otherNeighbour1.func_149730_j()) && !nZPos.func_149730_j() && !otherNeighbour2.func_149730_j()) {
                    meta = 3;
                }
                if ((nZPos.func_149730_j() || otherNeighbour2.func_149730_j()) && !nZNeg.func_149730_j() && !otherNeighbour1.func_149730_j()) {
                    meta = 2;
                }
            }
        } else {
            Block otherNeighbour1 = world.func_147439_a(x - 1, y, nZNeg == this ? z - 1 : z + 1);
            Block otherNeighbour2 = world.func_147439_a(x + 1, y, nZNeg == this ? z - 1 : z + 1);
            meta = 5;
            int otherMeta = nZNeg == this ? world.func_72805_g(x, y, z - 1) : world.func_72805_g(x, y, z + 1);
            if (otherMeta == 4) {
                meta = 4;
            }
            if ((nXNeg.func_149730_j() || otherNeighbour1.func_149730_j()) && !nXPos.func_149730_j() && !otherNeighbour2.func_149730_j()) {
                meta = 5;
            }
            if ((nXPos.func_149730_j() || otherNeighbour2.func_149730_j()) && !nXNeg.func_149730_j() && !otherNeighbour1.func_149730_j()) {
                meta = 4;
            }
        }
        world.func_72921_c(x, y, z, meta, 3);
    }

    public boolean func_149742_c(World worldIn, int x, int y, int z) {
        if (!this.canDoublechest) {
            return super.func_149742_c(worldIn, x, y, z);
        }
        int numSameNeighbours = 0;
        if (this.isSameBlock((IBlockAccess)worldIn, x - 1, y, z)) {
            ++numSameNeighbours;
        }
        if (this.isSameBlock((IBlockAccess)worldIn, x + 1, y, z)) {
            ++numSameNeighbours;
        }
        if (this.isSameBlock((IBlockAccess)worldIn, x, y, z - 1)) {
            ++numSameNeighbours;
        }
        if (this.isSameBlock((IBlockAccess)worldIn, x, y, z + 1)) {
            ++numSameNeighbours;
        }
        return numSameNeighbours <= 1 && !this.isThereANeighborChest(worldIn, x - 1, y, z) && !this.isThereANeighborChest(worldIn, x + 1, y, z) && !this.isThereANeighborChest(worldIn, x, y, z - 1) && !this.isThereANeighborChest(worldIn, x, y, z + 1);
    }

    private boolean isThereANeighborChest(World world, int x, int y, int z) {
        if (!this.canDoublechest || !this.isSameBlock((IBlockAccess)world, x, y, z)) {
            return false;
        }
        return this.isSameBlock((IBlockAccess)world, x - 1, y, z) || this.isSameBlock((IBlockAccess)world, x + 1, y, z) || this.isSameBlock((IBlockAccess)world, x, y, z - 1) || this.isSameBlock((IBlockAccess)world, x, y, z + 1);
    }

    public void func_149695_a(World worldIn, int x, int y, int z, Block neighbor) {
        super.func_149695_a(worldIn, x, y, z, neighbor);
        TileEntityARChest tileEntity = (TileEntityARChest)worldIn.func_147438_o(x, y, z);
        if (tileEntity != null) {
            tileEntity.func_145836_u();
        }
    }

    protected boolean isSameBlock(IBlockAccess world, int x, int y, int z) {
        return world.func_147439_a(x, y, z) == this;
    }

    public void func_149749_a(World worldIn, int x, int y, int z, Block blockBroken, int meta) {
        TileEntityARChest tileEntity = (TileEntityARChest)worldIn.func_147438_o(x, y, z);
        if (tileEntity != null) {
            for (int i = 0; i < tileEntity.func_70302_i_(); ++i) {
                ItemStack stack = tileEntity.func_70301_a(i);
                if (stack == null) continue;
                float rand1 = this.random.nextFloat() * 0.8f + 0.1f;
                float rand2 = this.random.nextFloat() * 0.8f + 0.1f;
                float randOffset = this.random.nextFloat() * 0.8f + 0.1f;
                while (stack.field_77994_a > 0) {
                    int droppedStackSize = this.random.nextInt(21) + 10;
                    if (droppedStackSize > stack.field_77994_a) {
                        droppedStackSize = stack.field_77994_a;
                    }
                    stack.field_77994_a -= droppedStackSize;
                    EntityItem itemEntity = new EntityItem(worldIn, (double)((float)x + rand1), (double)((float)y + rand2), (double)((float)z + randOffset), new ItemStack(stack.func_77973_b(), droppedStackSize, stack.func_77960_j()));
                    float yOffset = 0.05f;
                    itemEntity.field_70159_w = (float)this.random.nextGaussian() * 0.05f;
                    itemEntity.field_70181_x = (float)this.random.nextGaussian() * 0.05f + 0.2f;
                    itemEntity.field_70179_y = (float)this.random.nextGaussian() * 0.05f;
                    if (stack.func_77942_o()) {
                        itemEntity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
                    }
                    worldIn.func_72838_d((Entity)itemEntity);
                }
            }
        }
        super.func_149749_a(worldIn, x, y, z, blockBroken, meta);
    }

    public boolean func_149727_a(World worldIn, int x, int y, int z, EntityPlayer player, int side, float subX, float subY, float subZ) {
        TileEntity tileEntity = worldIn.func_147438_o(x, y, z);
        if (tileEntity == null || worldIn.isSideSolid(x, y + 1, z, ForgeDirection.DOWN) || TileEntityARChest.isOcelotBlockingChest(worldIn, x, y, z)) {
            return true;
        }
        if (this.canDoublechest) {
            if (worldIn.func_147439_a(x - 1, y, z) == this && (worldIn.isSideSolid(x - 1, y + 1, z, ForgeDirection.DOWN) || TileEntityARChest.isOcelotBlockingChest(worldIn, x - 1, y, z))) {
                return true;
            }
            if (worldIn.func_147439_a(x + 1, y, z) == this && (worldIn.isSideSolid(x + 1, y + 1, z, ForgeDirection.DOWN) || TileEntityARChest.isOcelotBlockingChest(worldIn, x + 1, y, z))) {
                return true;
            }
            if (worldIn.func_147439_a(x, y, z - 1) == this && (worldIn.isSideSolid(x, y + 1, z - 1, ForgeDirection.DOWN) || TileEntityARChest.isOcelotBlockingChest(worldIn, x, y, z - 1))) {
                return true;
            }
            if (worldIn.func_147439_a(x, y, z + 1) == this && (worldIn.isSideSolid(x, y + 1, z + 1, ForgeDirection.DOWN) || TileEntityARChest.isOcelotBlockingChest(worldIn, x, y, z + 1))) {
                return true;
            }
            if (this.isSameBlock((IBlockAccess)worldIn, x - 1, y, z)) {
                tileEntity = new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityARChest)worldIn.func_147438_o(x - 1, y, z)), (IInventory)tileEntity);
            }
            if (this.isSameBlock((IBlockAccess)worldIn, x + 1, y, z)) {
                tileEntity = new InventoryLargeChest("container.chestDouble", (IInventory)tileEntity, (IInventory)((TileEntityARChest)worldIn.func_147438_o(x + 1, y, z)));
            }
            if (this.isSameBlock((IBlockAccess)worldIn, x, y, z - 1)) {
                tileEntity = new InventoryLargeChest("container.chestDouble", (IInventory)((TileEntityARChest)worldIn.func_147438_o(x, y, z - 1)), (IInventory)tileEntity);
            }
            if (this.isSameBlock((IBlockAccess)worldIn, x, y, z + 1)) {
                tileEntity = new InventoryLargeChest("container.chestDouble", (IInventory)tileEntity, (IInventory)((TileEntityARChest)worldIn.func_147438_o(x, y, z + 1)));
            }
        }
        if (worldIn.field_72995_K) {
            return true;
        }
        player.func_71007_a((IInventory)tileEntity);
        return true;
    }

    public void setMass(float mass) {
        this.mass = mass;
    }

    @Override
    public float getMass(World w, int x, int y, int z, int meta) {
        return this.mass;
    }
}

