/*
 * Decompiled with CFR 0.152.
 */
package com.github.technus.tectech.loader.recipe;

import com.github.technus.tectech.TecTech;
import com.github.technus.tectech.loader.recipe.Assembler;
import com.github.technus.tectech.loader.recipe.AssemblyLine;
import com.github.technus.tectech.loader.recipe.CircuitAssembler;
import com.github.technus.tectech.loader.recipe.Crafting;
import com.github.technus.tectech.loader.recipe.Extractor;
import com.github.technus.tectech.loader.recipe.ResearchStationAssemblyLine;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.interfaces.IItemContainer;

public class BaseRecipeLoader {
    private static Class CUSTOM_ITEM_LIST;

    public static IItemContainer getItemContainer(String name) {
        return (IItemContainer)Enum.valueOf(CUSTOM_ITEM_LIST, name);
    }

    public static Materials getOrDefault(String name, Materials def) {
        Materials mat = Materials.get((String)name);
        return mat == Materials._NULL || mat == null ? def : mat;
    }

    public void run() {
        if (Mods.NewHorizonsCoreMod.isModLoaded()) {
            new Assembler().run();
            new AssemblyLine().run();
            new CircuitAssembler().run();
            new Crafting().run();
            new Extractor().run();
            new ResearchStationAssemblyLine().run();
        }
    }

    static {
        try {
            CUSTOM_ITEM_LIST = Class.forName("com.dreammaster.gthandler.CustomItemList");
        }
        catch (Exception e) {
            TecTech.LOGGER.error((Object)"NHCoreMod not present. Disabling all the recipes");
        }
    }
}

