/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.search;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.AttackDetector;
import com.jamesswafford.chess4j.board.Bitboard;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Magic;
import com.jamesswafford.chess4j.board.Move;
import com.jamesswafford.chess4j.board.squares.Direction;
import com.jamesswafford.chess4j.board.squares.Square;
import com.jamesswafford.chess4j.eval.Eval;
import com.jamesswafford.chess4j.pieces.Bishop;
import com.jamesswafford.chess4j.pieces.King;
import com.jamesswafford.chess4j.pieces.Knight;
import com.jamesswafford.chess4j.pieces.Pawn;
import com.jamesswafford.chess4j.pieces.Piece;
import com.jamesswafford.chess4j.pieces.Queen;
import com.jamesswafford.chess4j.pieces.Rook;
import java.util.HashMap;
import java.util.Map;

public class SEE {
    private static Map<Class<?>, Integer> pieceMap = new HashMap();

    public static int see(Board b, Move m) {
        int score = 0;
        if (m.promotion() != null) {
            score = SEE.scorePromotion(m);
        }
        if (m.captured() != null) {
            score += SEE.scoreCapture(b, m);
        }
        return score;
    }

    private static int scorePromotion(Move m) {
        int promoVal = pieceMap.get(m.promotion().getClass());
        return 10000 + promoVal;
    }

    private static int scoreCapture(Board b, Move m) {
        assert (m.captured() != null);
        assert (b.getPiece(m.from()) == null);
        int[] scores = new int[32];
        scores[0] = Eval.getPieceValue(m.captured());
        int scoresInd = 1;
        long whiteAttackersMap = AttackDetector.getAttackers(b, m.to(), Color.WHITE);
        long blackAttackersMap = AttackDetector.getAttackers(b, m.to(), Color.BLACK);
        Color sideToMove = b.getPlayerToMove();
        Square currentSq = m.from();
        Piece currentPiece = b.getPiece(m.to());
        int attackedPieceVal = Eval.getPieceValue(currentPiece);
        while (true) {
            if (!(currentPiece instanceof Knight) && !(currentPiece instanceof King)) {
                Direction dir = Direction.directionTo[m.to().value()][currentSq.value()];
                assert (dir != null);
                long targetSquares = Bitboard.rays[currentSq.value()][dir.value()];
                long xrays = dir.isDiagonal() ? Magic.getBishopMoves(b, currentSq.value(), targetSquares) & (b.getWhiteBishops() | b.getWhiteQueens() | b.getBlackBishops() | b.getBlackQueens()) : Magic.getRookMoves(b, currentSq.value(), targetSquares) & (b.getWhiteRooks() | b.getWhiteQueens() | b.getBlackRooks() | b.getBlackQueens());
                if ((xrays & b.getWhitePieces()) != 0L) {
                    whiteAttackersMap |= xrays;
                } else if ((xrays & b.getBlackPieces()) != 0L) {
                    blackAttackersMap |= xrays;
                }
            }
            if ((currentSq = SEE.findLeastValuable(b, sideToMove == Color.WHITE ? whiteAttackersMap : blackAttackersMap)) == null) break;
            if (sideToMove == Color.WHITE) {
                whiteAttackersMap ^= Bitboard.squares[currentSq.value()];
            } else {
                blackAttackersMap ^= Bitboard.squares[currentSq.value()];
            }
            currentPiece = b.getPiece(currentSq);
            assert (currentPiece != null);
            scores[scoresInd] = attackedPieceVal - scores[scoresInd - 1];
            ++scoresInd;
            attackedPieceVal = Eval.getPieceValue(currentPiece);
            sideToMove = Color.swap(sideToMove);
        }
        while (scoresInd > 1) {
            scores[--scoresInd - 1] = -Math.max(-scores[scoresInd - 1], scores[scoresInd]);
        }
        return scores[0];
    }

    private static Square findLeastValuable(Board board, long attackers) {
        Square lvSq = null;
        int lvScore = 0;
        while (attackers != 0L) {
            int sqInd = Bitboard.lsb(attackers);
            Square sq = Square.valueOf(sqInd);
            int myVal = Eval.getPieceValue(board.getPiece(sq));
            if (lvSq == null || myVal < lvScore) {
                lvSq = sq;
                lvScore = myVal;
            }
            attackers ^= Bitboard.squares[sqInd];
        }
        return lvSq;
    }

    static {
        pieceMap.put(King.class, 6);
        pieceMap.put(Queen.class, 5);
        pieceMap.put(Rook.class, 4);
        pieceMap.put(Bishop.class, 3);
        pieceMap.put(Knight.class, 2);
        pieceMap.put(Pawn.class, 1);
    }
}

