/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.render;

import com.cricketcraft.chisel.shadow.team.chisel.ctmlib.RenderBlocksCTM;
import com.cricketcraft.chisel.shadow.team.chisel.ctmlib.TextureSubmap;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import team.chisel.client.render.SubmapManagerBase;

public class SubmapManagerSpecialMaterial
extends SubmapManagerBase {
    private RenderBlocksCTMFullbright renderBlocksFullbright;
    private String color;
    private MaterialType materialType;
    private TextureSubmap submap;
    private TextureSubmap submapSmall;

    public SubmapManagerSpecialMaterial(String color, MaterialType materialType) {
        this.color = color;
        this.materialType = materialType;
    }

    @Override
    public IIcon getIcon(int side, int meta) {
        return this.submapSmall.getBaseIcon();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(String modName, Block block, IIconRegister register) {
        String materialName = this.materialType.name().toLowerCase();
        this.submap = new TextureSubmap(register.func_94245_a(modName + ":" + materialName + "/" + this.color + "-ctm"), 4, 4);
        this.submapSmall = new TextureSubmap(register.func_94245_a(modName + ":" + materialName + "/" + this.color), 2, 2);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public RenderBlocks createRenderContext(RenderBlocks rendererOld, Block block, IBlockAccess world) {
        if (this.renderBlocksFullbright == null) {
            this.renderBlocksFullbright = new RenderBlocksCTMFullbright();
        }
        this.renderBlocksFullbright.func_147775_a(block);
        this.renderBlocksFullbright.submap = this.submap;
        this.renderBlocksFullbright.submapSmall = this.submapSmall;
        return this.renderBlocksFullbright;
    }

    private static class RenderBlocksCTMFullbright
    extends RenderBlocksCTM {
        private RenderBlocksCTMFullbright() {
        }

        @Override
        protected void fillLightmap(int bottomLeft, int bottomRight, int topRight, int topLeft) {
            this.enableAmbientOcclusionIfInWorld();
            int maxLight = 0xF000F0;
            super.fillLightmap(maxLight, maxLight, maxLight, maxLight);
        }

        @Override
        protected void fillColormap(float bottomLeft, float bottomRight, float topRight, float topLeft, float[][] map) {
            this.enableAmbientOcclusionIfInWorld();
            int color = 0xFFFFFF;
            super.fillColormap(color, color, color, color, map);
        }

        @Override
        public boolean func_147784_q(Block block, int x, int y, int z) {
            boolean ret = super.func_147784_q(block, x, y, z);
            this.field_147863_w = false;
            return ret;
        }

        private void enableAmbientOcclusionIfInWorld() {
            if (this.inWorld) {
                this.field_147863_w = true;
            }
        }
    }

    public static enum MaterialType {
        NEONITE,
        GLOTEK;

    }
}

