/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.crafting;

import makeo.gadomancy.common.registration.RegisteredItems;
import makeo.gadomancy.common.research.SimpleResearchItem;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;

public class RecipeStickyJar
implements IArcaneRecipe {
    public boolean matches(IInventory inv, World world, EntityPlayer player) {
        return ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)SimpleResearchItem.getFullName("STICKYJAR")) && this.getJarItem(inv) != null;
    }

    public ItemStack getCraftingResult(IInventory inv) {
        ItemStack jarItem = this.getJarItem(inv);
        if (jarItem != null) {
            ItemStack result = jarItem.func_77946_l();
            result.field_77994_a = 1;
            NBTHelper.getData(result).func_74757_a("isStickyJar", true);
            return result;
        }
        return null;
    }

    private ItemStack getJarItem(IInventory inv) {
        int itemCount = 0;
        int invWidth = (int)Math.sqrt(inv.func_70302_i_());
        ItemStack jarItem = null;
        for (int i = 0; i < invWidth * invWidth; ++i) {
            boolean isSticky;
            ItemStack current = inv.func_70301_a(i);
            if (current == null) continue;
            if (++itemCount > 2) {
                return null;
            }
            if (jarItem != null) continue;
            if (current.func_77973_b() == Items.field_151123_aH) {
                return null;
            }
            boolean bl = isSticky = RegisteredItems.isStickyableJar(current) && (!current.func_77942_o() || !current.func_77978_p().func_74767_n("isStickyJar"));
            if (current.func_77973_b() != Items.field_151123_aH && !isSticky) {
                return null;
            }
            if (!isSticky) continue;
            int slimeSlot = i + invWidth;
            if (slimeSlot < 0 || slimeSlot > inv.func_70302_i_()) {
                return null;
            }
            ItemStack slime = inv.func_70301_a(slimeSlot);
            if (slime == null || slime.func_77973_b() != Items.field_151123_aH) {
                return null;
            }
            jarItem = current;
        }
        return jarItem;
    }

    public int getRecipeSize() {
        return 10;
    }

    public ItemStack getRecipeOutput() {
        return null;
    }

    public AspectList getAspects() {
        return new AspectList().add(Aspect.WATER, 10).add(Aspect.EARTH, 10);
    }

    public AspectList getAspects(IInventory inv) {
        return null;
    }

    public String getResearch() {
        return SimpleResearchItem.getFullName("STICKYJAR");
    }
}

