/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import gcewing.architecture.BaseBlockUtils;
import gcewing.architecture.BaseUtils;
import gcewing.architecture.BlockPos;
import gcewing.architecture.IBlockState;
import gcewing.architecture.Profile;
import gcewing.architecture.ShapeKind;
import gcewing.architecture.ShapeSymmetry;
import gcewing.architecture.ShapeTE;
import gcewing.architecture.Trans3;
import gcewing.architecture.Vector3;
import gcewing.architecture.WindowShapeKinds;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public enum Shape {
    RoofTile(0, "Roof Tile", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 2, 207),
    RoofOuterCorner(1, "Roof Outer Corner", ShapeKind.Roof, ShapeSymmetry.Unilateral, 1, 3, 79),
    RoofInnerCorner(2, "Roof Inner Corner", ShapeKind.Roof, ShapeSymmetry.Unilateral, 2, 3, 223),
    RoofRidge(3, "Gabled Roof Ridge", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 4, 15),
    RoofSmartRidge(4, "Hip Roof Ridge", ShapeKind.Roof, ShapeSymmetry.Quadrilateral, 1, 2, 15),
    RoofValley(5, "Gabled Roof Valley", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 2, 255),
    RoofSmartValley(6, "Hip Roof Valley", ShapeKind.Roof, ShapeSymmetry.Quadrilateral, 1, 1, 255),
    RoofOverhang(7, "Roof Overhang", ShapeKind.Model("roof_overhang"), ShapeSymmetry.Bilateral, 1, 2, 207),
    RoofOverhangOuterCorner(8, "Roof Overhang Outer Corner", ShapeKind.Model("roof_overhang_outer_corner"), ShapeSymmetry.Unilateral, 1, 3, 79),
    RoofOverhangInnerCorner(9, "Roof Overhang Inner Corner", ShapeKind.Model("roof_overhang_inner_corner"), ShapeSymmetry.Unilateral, 2, 3, 223),
    Cylinder(10, "Cylinder", ShapeKind.Model("cylinder_full_r8h16"), ShapeSymmetry.Quadrilateral, 1, 1, 255),
    CylinderHalf(11, "Half Cylinder", ShapeKind.Model("cylinder_half_r8h16"), ShapeSymmetry.Bilateral, 1, 1, 204),
    CylinderQuarter(12, "Quarter Cylinder", ShapeKind.Model("cylinder_quarter_r8h16"), ShapeSymmetry.Unilateral, 1, 1, 68),
    CylinderLargeQuarter(13, "Round Outer Corner", ShapeKind.Model("cylinder_quarter_r16h16"), ShapeSymmetry.Unilateral, 1, 1, 255),
    AnticylinderLargeQuarter(14, "Round Inner Corner", ShapeKind.Model("round_inner_corner"), ShapeSymmetry.Unilateral, 1, 2, 221),
    Pillar(15, "Round Pillar", ShapeKind.Model("cylinder_r6h16"), ShapeSymmetry.Quadrilateral, 1, 1, 262),
    Post(16, "Round Post", ShapeKind.Model("cylinder_r4h16"), ShapeSymmetry.Quadrilateral, 1, 4, 260),
    Pole(17, "Round Pole", ShapeKind.Model("cylinder_r2h16"), ShapeSymmetry.Quadrilateral, 1, 16, 258),
    BevelledOuterCorner(18, "Bevelled Outer Corner", ShapeKind.Model("bevelled_outer_corner"), ShapeSymmetry.Unilateral, 1, 3, 79),
    BevelledInnerCorner(19, "Bevelled Inner Corner", ShapeKind.Model("bevelled_inner_corner"), ShapeSymmetry.Unilateral, 1, 1, 223),
    PillarBase(20, "Round Pillar Base", ShapeKind.Model("pillar_base"), ShapeSymmetry.Quadrilateral, 1, 1, 255),
    DoricCapital(21, "Doric Capital", ShapeKind.Model("doric_capital"), ShapeSymmetry.Quadrilateral, 1, 1, 255),
    IonicCapital(22, "Ionic capital", ShapeKind.Model("ionic_capital"), ShapeSymmetry.Bilateral, 1, 1, 255),
    CorinthianCapital(23, "Corinthian capital", ShapeKind.Model("corinthian_capital"), ShapeSymmetry.Quadrilateral, 1, 1, 255),
    DoricTriglyph(24, "Triglyph", ShapeKind.Model("doric_triglyph", (Object[])Profile.Generic.lrStraight), ShapeSymmetry.Bilateral, 1, 1, 255),
    DoricTriglyphCorner(25, "Triglyph Corner", ShapeKind.Model("doric_triglyph_corner", (Object[])Profile.Generic.lrCorner), ShapeSymmetry.Bilateral, 1, 1, 255),
    DoricMetope(26, "Metope", ShapeKind.Model("doric_metope", (Object[])Profile.Generic.lrStraight), ShapeSymmetry.Bilateral, 1, 1, 255),
    Architrave(27, "Architrave", ShapeKind.Model("architrave", (Object[])Profile.Generic.lrStraight), ShapeSymmetry.Bilateral, 1, 1, 255),
    ArchitraveCorner(28, "Architrave Corner", ShapeKind.Model("architrave_corner", (Object[])Profile.Generic.lrCorner), ShapeSymmetry.Unilateral, 1, 1, 255),
    WindowFrame(30, "Window Frame", WindowShapeKinds.PlainWindow, ShapeSymmetry.Bilateral, 1, 4, 514),
    WindowCorner(31, "Window Corner", WindowShapeKinds.CornerWindow, ShapeSymmetry.Unilateral, 1, 2, 514),
    WindowMullion(32, "Window Mullion", WindowShapeKinds.MullionWindow, ShapeSymmetry.Bilateral, 1, 2, 514),
    SphereFull(33, "Sphere", ShapeKind.Model("sphere_full_r8"), ShapeSymmetry.Quadrilateral, 1, 1, 255),
    SphereHalf(34, "Hemisphere", ShapeKind.Model("sphere_half_r8"), ShapeSymmetry.Quadrilateral, 1, 2, 15),
    SphereQuarter(35, "Quarter Sphere", ShapeKind.Model("sphere_quarter_r8"), ShapeSymmetry.Bilateral, 1, 4, 12),
    SphereEighth(36, "Quarter Hemisphere", ShapeKind.Model("sphere_eighth_r8"), ShapeSymmetry.Unilateral, 1, 8, 4),
    SphereEighthLarge(37, "Round Outer Corner Cap", ShapeKind.Model("sphere_eighth_r16"), ShapeSymmetry.Unilateral, 1, 1, 255),
    SphereEighthLargeRev(38, "Round Inner Corner Cap", ShapeKind.Model("sphere_eighth_r16_rev"), ShapeSymmetry.Unilateral, 1, 1, 223),
    RoofOverhangGableLH(40, "Gable Overhang LH", ShapeKind.Model("roof_overhang_gable_lh"), ShapeSymmetry.Bilateral, 1, 4, 72),
    RoofOverhangGableRH(41, "Gable Overhang RH", ShapeKind.Model("roof_overhang_gable_rh"), ShapeSymmetry.Bilateral, 1, 4, 132),
    RoofOverhangGableEndLH(42, "Gable Overhang LH End", ShapeKind.Model("roof_overhang_gable_end_lh"), ShapeSymmetry.Bilateral, 1, 4, 72),
    RoofOverhangGableEndRH(43, "Gable Overhang RH End", ShapeKind.Model("roof_overhang_gable_end_rh"), ShapeSymmetry.Bilateral, 1, 4, 72),
    RoofOverhangRidge(44, "Ridge Overhang", ShapeKind.Model("roof_overhang_gable_ridge"), ShapeSymmetry.Bilateral, 1, 4, 12),
    RoofOverhangValley(45, "Valley Overhang", ShapeKind.Model("roof_overhang_gable_valley"), ShapeSymmetry.Bilateral, 1, 4, 204),
    CorniceLH(50, "Cornice LH", ShapeKind.Model("cornice_lh"), ShapeSymmetry.Bilateral, 1, 4, 72),
    CorniceRH(51, "Cornice RH", ShapeKind.Model("cornice_rh"), ShapeSymmetry.Bilateral, 1, 4, 132),
    CorniceEndLH(52, "Cornice LH End", ShapeKind.Model("cornice_end_lh"), ShapeSymmetry.Bilateral, 1, 4, 72),
    CorniceEndRH(53, "Cornice RH End", ShapeKind.Model("cornice_end_rh"), ShapeSymmetry.Bilateral, 1, 4, 72),
    CorniceRidge(54, "Cornice Ridge", ShapeKind.Model("cornice_ridge"), ShapeSymmetry.Bilateral, 1, 4, 12),
    CorniceValley(55, "Cornice Valley", ShapeKind.Model("cornice_valley"), ShapeSymmetry.Bilateral, 1, 4, 204),
    CorniceBottom(56, "Cornice Bottom", ShapeKind.Model("cornice_bottom"), ShapeSymmetry.Bilateral, 1, 4, 12),
    CladdingSheet(60, "Cladding", ShapeKind.Cladding, null, 1, 1, 0),
    ArchD1(61, "Arch Diameter 1", ShapeKind.Model("arch_d1"), ShapeSymmetry.Bilateral, 1, 1, 255, 1),
    ArchD2(62, "Arch Diameter 2", ShapeKind.Model("arch_d2"), ShapeSymmetry.Bilateral, 1, 2, 252, 1),
    ArchD3A(63, "Arch Diameter 3 Part A", ShapeKind.Model("arch_d3a"), ShapeSymmetry.Bilateral, 1, 2, 204, 1),
    ArchD3B(64, "Arch Diameter 3 Part B", ShapeKind.Model("arch_d3b"), ShapeSymmetry.Bilateral, 1, 1, 252, 1),
    ArchD3C(65, "Arch Diameter 3 Part C", ShapeKind.Model("arch_d3c"), ShapeSymmetry.Bilateral, 1, 1, 255, 1),
    ArchD4A(66, "Arch Diameter 4 Part A", ShapeKind.Model("arch_d4a"), ShapeSymmetry.Bilateral, 1, 2, 204, 1),
    ArchD4B(67, "Arch Diameter 4 Part B", ShapeKind.Model("arch_d4b"), ShapeSymmetry.Bilateral, 1, 1, 252, 1),
    ArchD4C(68, "Arch Diameter 4 Part C", ShapeKind.Model("arch_d4c"), ShapeSymmetry.Bilateral, 1, 2, 0, 1),
    BanisterPlainBottom(70, "Plain Banister Bottom Transition", ShapeKind.Banister("balustrade_stair_plain_bottom"), ShapeSymmetry.Bilateral, 1, 10, 0, 2),
    BanisterPlain(71, "Plain Banister", ShapeKind.Banister("balustrade_stair_plain"), ShapeSymmetry.Bilateral, 1, 10, 0, 2),
    BanisterPlainTop(72, "Plain Banister Top Transition", ShapeKind.Banister("balustrade_stair_plain_top"), ShapeSymmetry.Bilateral, 1, 10, 0, 2),
    BalustradeFancy(73, "Fancy Balustrade", ShapeKind.Model("balustrade_fancy"), ShapeSymmetry.Bilateral, 1, 5, 0),
    BalustradeFancyCorner(74, "Fancy Corner Balustrade", ShapeKind.Model("balustrade_fancy_corner"), ShapeSymmetry.Unilateral, 1, 2, 0),
    BalustradeFancyWithNewel(75, "Fancy Balustrade with Newel", ShapeKind.Model("balustrade_fancy_with_newel"), ShapeSymmetry.Bilateral, 1, 3, 0),
    BalustradeFancyNewel(76, "Fancy Newel", ShapeKind.Model("balustrade_fancy_newel"), ShapeSymmetry.Unilateral, 1, 4, 0),
    BalustradePlain(77, "Plain Balustrade", ShapeKind.Model("balustrade_plain"), ShapeSymmetry.Bilateral, 1, 10, 0),
    BalustradePlainOuterCorner(78, "Plain Outer Corner Balustrade", ShapeKind.Model("balustrade_plain_outer_corner"), ShapeSymmetry.Unilateral, 1, 4, 0),
    BalustradePlainWithNewel(79, "Plain Balustrade with Newel", ShapeKind.Model("balustrade_plain_with_newel"), ShapeSymmetry.Bilateral, 1, 6, 0),
    BanisterPlainEnd(80, "Plain Banister End", ShapeKind.Banister("balustrade_stair_plain_end"), ShapeSymmetry.Bilateral, 1, 8, 0, 2),
    BanisterFancyNewelTall(81, "Tall Fancy Newel", ShapeKind.Model("balustrade_fancy_newel_tall"), ShapeSymmetry.Unilateral, 1, 2, 0),
    BalustradePlainInnerCorner(82, "Plain Inner Corner Balustrade", ShapeKind.Model("balustrade_plain_inner_corner"), ShapeSymmetry.Unilateral, 1, 8, 0),
    BalustradePlainEnd(83, "Plain Balustrade End", ShapeKind.Banister("balustrade_plain_end"), ShapeSymmetry.Bilateral, 1, 8, 0, 2),
    BanisterFancyBottom(84, "Fancy Banister Bottom Transition", ShapeKind.Banister("balustrade_stair_fancy_bottom"), ShapeSymmetry.Bilateral, 1, 5, 0, 2),
    BanisterFancy(85, "Fancy Banister", ShapeKind.Banister("balustrade_stair_fancy"), ShapeSymmetry.Bilateral, 1, 5, 0, 2),
    BanisterFancyTop(86, "Fancy Banister Top Transition", ShapeKind.Banister("balustrade_stair_fancy_top"), ShapeSymmetry.Bilateral, 1, 5, 0, 2),
    BanisterFancyEnd(87, "Fancy Banister End", ShapeKind.Banister("balustrade_stair_fancy_end"), ShapeSymmetry.Bilateral, 1, 2, 0, 2),
    BanisterPlainInnerCorner(88, "Plain Banister Inner Corner", ShapeKind.Model("balustrade_stair_plain_inner_corner"), ShapeSymmetry.Unilateral, 1, 6, 0),
    Slab(90, "Slab", ShapeKind.Model("slab"), ShapeSymmetry.Quadrilateral, 1, 2, 0),
    Stairs(91, "Stairs", ShapeKind.Model("stairs", (Object[])Profile.Generic.lrStraight), ShapeSymmetry.Bilateral, 3, 4, 0),
    StairsOuterCorner(92, "Stairs Outer Corner", ShapeKind.Model("stairs_outer_corner", (Object[])Profile.Generic.lrCorner), ShapeSymmetry.Unilateral, 2, 3, 0),
    StairsInnerCorner(93, "Stairs Inner Corner", ShapeKind.Model("stairs_inner_corner", (Object[])Profile.Generic.rlCorner), ShapeSymmetry.Unilateral, 1, 1, 0),
    SlopeTileA1(94, "Slope A Start", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 1, 207),
    SlopeTileA2(95, "Slope A End", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 3, 15),
    SlopeTileB1(96, "Slope B Start", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 1, 255),
    SlopeTileB2(97, "Slope B Middle", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 2, 207),
    SlopeTileB3(98, "Slope B End", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 3, 15),
    SlopeTileC1(99, "Slope C 1", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 1, 255),
    SlopeTileC2(100, "Slope C 2", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 2, 207),
    SlopeTileC3(101, "Slope C 3", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 3, 15),
    SlopeTileC4(102, "Slope C 4", ShapeKind.Roof, ShapeSymmetry.Bilateral, 1, 4, 15);

    public int id;
    public String title;
    public ShapeKind kind;
    public ShapeSymmetry symmetry;
    public int materialUsed;
    public int itemsProduced;
    public int occlusionMask;
    public int flags;
    public static Shape[] values;
    protected static Map<Integer, Shape> idMap;
    public static boolean debugPlacement;

    public static Shape forId(int id) {
        Shape shape = idMap.get(id);
        if (shape == null) {
            shape = RoofTile;
        }
        return shape;
    }

    private Shape(int id, String title, ShapeKind kind, ShapeSymmetry sym, int used, int made, int occ) {
        this(id, title, kind, sym, used, made, occ, 0);
    }

    private Shape(int id, String title, ShapeKind kind, ShapeSymmetry sym, int used, int made, int occ, int flags) {
        this.id = id;
        this.title = title;
        this.kind = kind;
        this.symmetry = sym;
        this.materialUsed = used;
        this.itemsProduced = made;
        this.occlusionMask = occ;
        this.flags = flags;
    }

    protected void orientOnPlacement(EntityPlayer player, ShapeTE te, BlockPos npos, IBlockState nstate, TileEntity nte, EnumFacing face, Vector3 hit) {
        if (te.shape.kind.orientOnPlacement(player, te, npos, nstate, nte, face, hit)) {
            return;
        }
        this.orientFromHitPosition(player, te, face, hit);
    }

    protected void orientFromHitPosition(EntityPlayer player, ShapeTE te, EnumFacing face, Vector3 hit) {
        int side;
        switch (face) {
            case UP: {
                side = this.rightSideUpSide();
                break;
            }
            case DOWN: {
                if (te.shape.kind.canPlaceUpsideDown()) {
                    side = this.upsideDownSide();
                    break;
                }
                side = this.rightSideUpSide();
                break;
            }
            default: {
                side = player.func_70093_af() ? BaseUtils.oppositeFacing(face).ordinal() : (hit.y > 0.0 && te.shape.kind.canPlaceUpsideDown() ? this.upsideDownSide() : this.rightSideUpSide());
            }
        }
        int turn = Shape.turnForPlacementHit(side, hit, this.symmetry);
        if (debugPlacement && !BaseBlockUtils.getTileEntityWorld((TileEntity)te).field_72995_K) {
            System.out.printf("Shape.orientFromHitPosition: face %s global hit %s\n", face, hit);
            System.out.printf("Shape.orientFromHitPosition: side %s turn %s symmetry %s\n", new Object[]{side, turn, te.shape.symmetry});
        }
        te.setSide(side);
        te.setTurn(turn);
        if ((this.flags & 2) != 0) {
            te.setOffsetX(this.offsetXForPlacementHit(side, turn, hit));
            if (debugPlacement && !BaseBlockUtils.getTileEntityWorld((TileEntity)te).field_72995_K) {
                System.out.printf("Shape.orientFromHitPosition: kind = %s offsetX = %.3f\n", this.kind, te.getOffsetX());
            }
        }
    }

    public double offsetXForPlacementHit(int side, int turn, Vector3 hit) {
        Vector3 h = Trans3.sideTurn(side, turn).ip(hit);
        return this.signedPlacementOffsetX(h.x);
    }

    public double signedPlacementOffsetX(double sign) {
        double offx = this.kind.placementOffsetX();
        if (sign < 0.0) {
            offx = -offx;
        }
        return offx;
    }

    protected int rightSideUpSide() {
        if (this.isPlacedUnderneath()) {
            return 1;
        }
        return 0;
    }

    protected int upsideDownSide() {
        if (this.isPlacedUnderneath()) {
            return 0;
        }
        return 1;
    }

    protected boolean isPlacedUnderneath() {
        return (this.flags & 1) != 0;
    }

    public static int turnForPlacementHit(int side, Vector3 hit, ShapeSymmetry symmetry) {
        Vector3 h = Trans3.sideTurn(side, 0).ip(hit);
        return Shape.turnForPlacementHit(symmetry, h.x, h.z);
    }

    private static int turnForPlacementHit(ShapeSymmetry symmetry, double x, double z) {
        switch (symmetry) {
            case Quadrilateral: {
                return 0;
            }
            case Bilateral: {
                if (Math.abs(z) > Math.abs(x)) {
                    return z < 0.0 ? 2 : 0;
                }
                return x > 0.0 ? 1 : 3;
            }
            case Unilateral: {
                if (z > 0.0) {
                    return x < 0.0 ? 0 : 1;
                }
                return x > 0.0 ? 2 : 3;
            }
        }
        return 0;
    }

    static {
        values = Shape.values();
        idMap = new HashMap<Integer, Shape>();
        for (Shape s : values) {
            idMap.put(s.id, s);
        }
        debugPlacement = false;
    }
}

