/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevesfactory.nbt;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.nbt.NBTTagCompound;
import vswe.stevesfactory.CollisionHelper;
import vswe.stevesfactory.interfaces.GuiManager;
import vswe.stevesfactory.interfaces.IInterfaceRenderer;
import vswe.stevesfactory.nbt.NBTNode;

@SideOnly(value=Side.CLIENT)
public class NBTRenderer
implements IInterfaceRenderer {
    private NBTNode root;
    private static final int POS_X = 5;
    private static final int POS_Y = 5;
    private static final int LINE_HEIGHT = 8;
    private static final int INDENT_WIDTH = 5;
    private static final int VALUE_OFFSET = 70;
    private static final int TEXT_OFFSET = 10;
    private static final int NODE_SIZE = 4;
    private static final int NODE_SRC_X = 120;
    private static final int NODE_SRC_Y = 156;

    public NBTRenderer(NBTTagCompound compound) {
        this.root = NBTNode.generateNodes(compound);
    }

    @Override
    public void draw(GuiManager gui, int mX, int mY) {
        this.drawNode(this.root, gui, mX, mY);
    }

    private void drawNode(NBTNode node, GuiManager gui, int mX, int mY) {
        int x = 5 + 5 * node.getCachedDepth();
        int y = 5 + 8 * node.getCachedLine();
        if (node.getCachedDepth() >= 0) {
            gui.drawString(node.getName(), x + 10, y, 0.7f, 0x404040);
            gui.drawString(node.getValue(), x + 10 + 70, y, 0.7f, 0x404040);
        }
        if (node.getNodes() != null) {
            if (node.getCachedDepth() >= 0) {
                int nodeSrcX = CollisionHelper.inBounds(x, y, 4, 4, mX, mY) ? 1 : 0;
                int nodeSrcY = node.isOpen() ? 1 : 0;
                gui.drawTexture(x, y, 120 + nodeSrcX * 4, 156 + nodeSrcY * 4, 4, 4);
            }
            if (node.isOpen()) {
                for (NBTNode child : node.getNodes()) {
                    this.drawNode(child, gui, mX, mY);
                }
            }
        }
    }

    @Override
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onClick(GuiManager gui, int mX, int mY, int button) {
        if (button == 1) {
            gui.getManager().specialRenderer = null;
        } else {
            this.onNodeClick(this.root, mX, mY);
        }
    }

    private boolean onNodeClick(NBTNode node, int mX, int mY) {
        int x = 5 + 5 * node.getCachedDepth();
        int y = 5 + 8 * node.getCachedLine();
        if (node.getNodes() != null) {
            if (node.getCachedDepth() >= 0 && CollisionHelper.inBounds(x, y, 4, 4, mX, mY)) {
                node.setOpen(!node.isOpen());
                this.root.updatePosition();
                return true;
            }
            if (node.isOpen()) {
                for (NBTNode child : node.getNodes()) {
                    if (!this.onNodeClick(child, mX, mY)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void onDrag(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onRelease(GuiManager gui, int mX, int mY) {
    }

    @Override
    public void onKeyTyped(GuiManager gui, char c, int k) {
    }

    @Override
    public void onScroll(int scroll) {
    }
}

