/*
 * Decompiled with CFR 0.152.
 */
package squeek.tictooltips;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import squeek.tictooltips.ModTiCTooltips;
import squeek.tictooltips.helpers.ColorHelper;
import squeek.tictooltips.helpers.CompatibilityHelper;
import squeek.tictooltips.helpers.KeyHelper;
import squeek.tictooltips.helpers.MathHelper;
import squeek.tictooltips.helpers.PatternHelper;
import squeek.tictooltips.helpers.StringHelper;
import squeek.tictooltips.helpers.ToolHelper;
import squeek.tictooltips.helpers.ToolPartHelper;
import squeek.tictooltips.proxy.ProxyExtraTiC;
import squeek.tictooltips.proxy.ProxyIguanaTweaks;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.ArrowMaterial;
import tconstruct.library.tools.BowMaterial;
import tconstruct.library.tools.BowstringMaterial;
import tconstruct.library.tools.FletchingMaterial;
import tconstruct.library.tools.FletchlingLeafMaterial;
import tconstruct.library.tools.ToolCore;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IPattern;
import tconstruct.library.util.IToolPart;
import tconstruct.library.weaponry.ArrowShaftMaterial;
import tconstruct.library.weaponry.IAmmo;
import tconstruct.library.weaponry.ProjectileWeapon;
import tconstruct.weaponry.weapons.Crossbow;
import tconstruct.weaponry.weapons.LongBow;

public class TooltipHandler {
    @SubscribeEvent
    public void onItemTooltip(ItemTooltipEvent event) {
        if (event.entityPlayer == null) {
            return;
        }
        if (event.getResult() == Event.Result.DENY) {
            return;
        }
        Item item = event.itemStack.func_77973_b();
        if (item instanceof IToolPart) {
            if (ToolPartHelper.isShard(item)) {
                return;
            }
            event.toolTip.addAll(this.getMaterialTooltip(event.itemStack));
        } else if (item instanceof IPattern && !ModTiCTooltips.hasIguanaTweaks) {
            event.toolTip.addAll(this.getPatternTooltip(event.itemStack));
        } else if (item instanceof ToolCore && ToolHelper.hasToolTag(event.itemStack)) {
            String plusPrefix = "\u00a79+";
            String maxDamagePrefix = StatCollector.func_74838_a((String)"attribute.name.ammo.maxAttackDamage");
            int toolTipIndex = 0;
            if (event.toolTip.size() > 1) {
                toolTipIndex = -1;
                if (((String)event.toolTip.get(event.toolTip.size() - 1)).startsWith(plusPrefix)) {
                    toolTipIndex = event.toolTip.size() - 1;
                } else if (((String)event.toolTip.get(event.toolTip.size() - 1)).startsWith(maxDamagePrefix)) {
                    toolTipIndex = event.toolTip.size() - 1;
                } else if (event.itemStack.func_77948_v()) {
                    NBTTagList enchantTagList = event.itemStack.func_77986_q();
                    short enchantID = enchantTagList.func_150305_b(0).func_74765_d("id");
                    short enchantLevel = enchantTagList.func_150305_b(0).func_74765_d("lvl");
                    String enchantName = Enchantment.field_77331_b[enchantID].func_77316_c((int)enchantLevel);
                    toolTipIndex = event.toolTip.indexOf(enchantName);
                } else {
                    for (int toolTipSearchIndex = 0; toolTipSearchIndex < event.toolTip.size(); ++toolTipSearchIndex) {
                        if (!((String)event.toolTip.get(toolTipSearchIndex)).startsWith(plusPrefix) && !((String)event.toolTip.get(toolTipSearchIndex)).startsWith(maxDamagePrefix)) continue;
                        toolTipIndex = toolTipSearchIndex;
                        break;
                    }
                }
                if (toolTipIndex == -1) {
                    ArrayList tinkersTooltip = new ArrayList();
                    ((ToolCore)item).func_77624_a(event.itemStack, event.entityPlayer, tinkersTooltip, event.showAdvancedItemTooltips);
                    toolTipIndex = Math.max(0, (tinkersTooltip.size() > 0 ? Math.min(event.toolTip.size(), event.toolTip.indexOf(tinkersTooltip.get(0)) + tinkersTooltip.size()) : event.toolTip.size()) - 1);
                }
            }
            if (toolTipIndex > 1 && ((String)event.toolTip.get(toolTipIndex)).startsWith(maxDamagePrefix)) {
                event.toolTip.remove(toolTipIndex);
                --toolTipIndex;
            }
            while (toolTipIndex > 1 && ((String)event.toolTip.get(toolTipIndex - 1)).startsWith(maxDamagePrefix)) {
                event.toolTip.remove(toolTipIndex - 1);
                toolTipIndex -= 2;
            }
            while (toolTipIndex > 1 && ((String)event.toolTip.get(toolTipIndex - 1)).startsWith(plusPrefix)) {
                --toolTipIndex;
            }
            while (toolTipIndex > 1 && ((String)event.toolTip.get(toolTipIndex - 1)).equals("")) {
                event.toolTip.remove(toolTipIndex - 1);
                --toolTipIndex;
            }
            boolean ctrlDown = KeyHelper.isCtrlKeyDown();
            boolean shiftDown = KeyHelper.isShiftKeyDown();
            if (shiftDown && !ctrlDown) {
                if (toolTipIndex > 1) {
                    event.toolTip.add(toolTipIndex++, "");
                }
                List<String> toolStats = this.getToolStatsTooltip(event.itemStack);
                event.toolTip.addAll(toolTipIndex, toolStats);
                if ((toolTipIndex += toolStats.size()) >= event.toolTip.size() || !((String)event.toolTip.get(toolTipIndex)).equals("")) {
                    event.toolTip.add(toolTipIndex++, "");
                }
            } else if (ctrlDown) {
                while (event.toolTip.size() > 1) {
                    event.toolTip.remove(1);
                }
                toolTipIndex = event.toolTip.size();
                List<String> toolMaterials = this.getToolMaterialsTooltip(event.itemStack);
                event.toolTip.addAll(toolTipIndex, toolMaterials);
            } else {
                if (ModTiCTooltips.hasIguanaTweaks) {
                    event.toolTip.add(toolTipIndex, "");
                }
                event.toolTip.add(toolTipIndex++, StatCollector.func_74837_a((String)"tictooltips.hold.key.for.stats", (Object[])new Object[]{EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.ITALIC + "Shift" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
                event.toolTip.add(toolTipIndex++, StatCollector.func_74837_a((String)"tictooltips.hold.key.for.materials", (Object[])new Object[]{EnumChatFormatting.DARK_AQUA.toString() + EnumChatFormatting.ITALIC + "Ctrl" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
            }
        }
    }

    private List<String> getMaterialTooltip(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        int matID = ((IToolPart)item).getMaterialID(itemStack);
        return this.getMaterialTooltip(matID, item);
    }

    private List<String> getMaterialTooltip(int matID, Item item) {
        return this.getMaterialTooltip(matID, item, null);
    }

    private List<String> getMaterialTooltip(int matID, Item item, ToolCore tool) {
        boolean hasTool;
        ArrayList<String> toolTip = new ArrayList<String>();
        ToolMaterial mat = TConstructRegistry.getMaterial((int)matID);
        boolean bl = hasTool = tool != null;
        if (mat == null) {
            return toolTip;
        }
        if (!mat.ability().equals("")) {
            toolTip.add(mat.style() + CompatibilityHelper.getLocalizedAbility(mat));
        }
        if (mat.shoddy() != 0.0f) {
            for (int index = 0; index < toolTip.size(); ++index) {
                if (!((String)toolTip.get(index)).contains(StringHelper.getShoddinessTypeString(mat.shoddy()))) continue;
                toolTip.set(index, (String)toolTip.get(index) + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)"tictooltips.material.shoddiness.modifier", (Object[])new Object[]{ToolPartHelper.getShoddinessString(mat.shoddy()) + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
                break;
            }
        }
        if (ToolPartHelper.isArrowHead(item)) {
            boolean isToolAnArrow;
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
            ArrowMaterial arrowMat = TConstructRegistry.getArrowMaterial((int)matID);
            boolean bl2 = isToolAnArrow = hasTool && ToolHelper.isProjectile(tool) && ToolHelper.isAmmo(tool);
            if (arrowMat != null && (!hasTool || isToolAnArrow)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation22") + ToolPartHelper.getBreakChanceString(arrowMat.breakChance));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation8") + ToolPartHelper.getWeightString(arrowMat.mass));
            }
        } else if (ToolPartHelper.isArrowFletching(item)) {
            FletchingMaterial fletchingMat = CompatibilityHelper.getFletchingMaterial(matID);
            if (fletchingMat != null) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityModifierString(fletchingMat.durabilityModifier));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation22") + ToolPartHelper.getBreakChanceString(fletchingMat.breakChance));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation9") + ToolPartHelper.getAccuracyString(fletchingMat.accuracy));
            }
        } else if (ToolPartHelper.isBowString(item)) {
            BowstringMaterial bowstringMat = (BowstringMaterial)TConstructRegistry.getCustomMaterial((int)matID, BowstringMaterial.class);
            if (bowstringMat != null) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation6") + ToolPartHelper.getBowStringDrawspeedModifierString(bowstringMat.drawspeedModifier));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getBowStringDurabilityModifierString(bowstringMat.durabilityModifier));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation7") + ToolPartHelper.getBowStringArrowSpeedModifierString(bowstringMat.flightSpeedModifier));
            }
        } else {
            if (mat.reinforced() > 0) {
                toolTip.add(mat.style() + StringHelper.getReinforcedString(mat.reinforced()));
            }
            if (ToolPartHelper.isRod(item) || ToolPartHelper.isArrowShaft(item)) {
                boolean isToolAnArrow;
                ArrowShaftMaterial arrowShaftMat = (ArrowShaftMaterial)TConstructRegistry.getCustomMaterial((int)matID, ArrowShaftMaterial.class);
                boolean isArrowMat = arrowShaftMat != null && matID <= 0 && ToolPartHelper.isArrowRod(item);
                boolean bl3 = isToolAnArrow = hasTool && ToolHelper.isProjectile(tool) && ToolHelper.isAmmo(tool);
                if (isToolAnArrow || isArrowMat && KeyHelper.isShiftKeyDown()) {
                    if (arrowShaftMat != null && (!hasTool || isToolAnArrow)) {
                        toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityModifierString(arrowShaftMat.durabilityModifier));
                        toolTip.add(StringHelper.getLocalizedString("gui.toolstation22") + ToolPartHelper.getBreakChanceString(arrowShaftMat.fragility));
                        toolTip.add(StringHelper.getLocalizedString("gui.toolstation8") + ToolPartHelper.getWeightString(arrowShaftMat.weight));
                    }
                } else {
                    String durabilityModifierTitle = StatCollector.func_74837_a((String)"tictooltips.material.durability.modifier", (Object[])new Object[]{StringHelper.getLocalizedString("gui.toolstation2").replaceFirst(": ", "")});
                    toolTip.add(durabilityModifierTitle + ToolPartHelper.getHandleModifierString(mat.handleModifier));
                    if (!hasTool && isArrowMat) {
                        toolTip.add(StatCollector.func_74837_a((String)"tictooltips.hold.key.for.bow.stats", (Object[])new Object[]{EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.ITALIC + "Shift" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
                    }
                }
            } else if (ToolPartHelper.isToolHead(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation14") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
                int harvestLevel = mat.harvestLevel();
                if (ModTiCTooltips.hasIguanaTweaks) {
                    harvestLevel = ProxyIguanaTweaks.getUnboostedHarvestLevel(item, harvestLevel);
                }
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation15") + ToolPartHelper.getHarvestLevelString(harvestLevel));
            } else if (ToolPartHelper.isWeaponMiningHead(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation14") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation15") + ToolPartHelper.getHarvestLevelString(mat.harvestLevel()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
            } else if (ToolPartHelper.isWeaponToolHead(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation16") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
            } else if (ToolPartHelper.isChiselHead(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation16") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
            } else if (ToolPartHelper.isWeaponHead(item) || ToolPartHelper.isShurikenPart(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
            } else if (ToolPartHelper.isPlate(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                if (!hasTool || ToolHelper.isHarvestTool(tool)) {
                    toolTip.add(StringHelper.getLocalizedString("gui.toolstation14") + ToolPartHelper.getMiningSpeedString(mat.toolSpeed()));
                }
                if (!hasTool || ToolHelper.isWeapon(tool)) {
                    toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ToolPartHelper.getAttackString(mat.attack()));
                }
            } else if (ToolPartHelper.isBowLimb(item) || ToolPartHelper.isCrossbowLimb(item) || ToolPartHelper.isCrossbowBody(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                BowMaterial bowMat = TConstructRegistry.getBowMaterial((int)matID);
                if (bowMat != null) {
                    toolTip.add(StringHelper.getLocalizedString("gui.toolstation6") + ToolPartHelper.getBowDrawSpeedString(bowMat.drawspeed));
                    toolTip.add(StringHelper.getLocalizedString("gui.toolstation7") + ToolPartHelper.getArrowSpeedString(bowMat.flightSpeedMax));
                }
            } else if (ToolPartHelper.isBoltPart(item)) {
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ToolPartHelper.getDurabilityString(mat.durability()));
                ArrowMaterial arrowMat = TConstructRegistry.getArrowMaterial((int)matID);
                if (arrowMat != null) {
                    toolTip.add(StringHelper.getLocalizedString("gui.toolstation22") + ToolPartHelper.getBreakChanceString(arrowMat.breakChance));
                    toolTip.add(StringHelper.getLocalizedString("gui.toolstation8") + ToolPartHelper.getWeightString(arrowMat.mass));
                }
            } else if (ToolPartHelper.isToughBinding(item) || ToolPartHelper.isFullWeaponGuard(item)) {
                String durabilityModifierTitle = StatCollector.func_74837_a((String)"tictooltips.material.durability.modifier", (Object[])new Object[]{StringHelper.getLocalizedString("gui.toolstation2").replaceFirst(": ", "")});
                toolTip.add(durabilityModifierTitle + ToolPartHelper.getHandleModifierString(mat.handleDurability()));
            }
        }
        return toolTip;
    }

    private List<String> getPatternTooltip(ItemStack itemStack) {
        List<String> validMats = null;
        ArrayList<String> toolTip = new ArrayList<String>();
        if (PatternHelper.isBowstringPattern(itemStack.func_77973_b(), itemStack.func_77960_j())) {
            validMats = PatternHelper.getValidCustomMaterialsOfType(BowstringMaterial.class);
        } else if (PatternHelper.isFletchingPattern(itemStack.func_77973_b(), itemStack.func_77960_j())) {
            validMats = PatternHelper.getValidCustomMaterialsOfType(FletchingMaterial.class);
            validMats.addAll(PatternHelper.getValidCustomMaterialsOfType(FletchlingLeafMaterial.class));
        }
        if (validMats != null && !validMats.isEmpty()) {
            toolTip.add(StatCollector.func_74838_a((String)"tictooltips.pattern.valid.materials"));
            for (String matName : validMats) {
                if (toolTip.size() < 7 || KeyHelper.isShiftKeyDown()) {
                    toolTip.add(" - " + matName);
                    continue;
                }
                toolTip.add(StatCollector.func_74837_a((String)"tictooltips.hold.key.for.more", (Object[])new Object[]{EnumChatFormatting.YELLOW.toString() + EnumChatFormatting.ITALIC + "Shift" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY}));
                break;
            }
        }
        return toolTip;
    }

    public List<String> getDurabilityTooltip(NBTTagCompound toolTag, ItemStack itemStack) {
        ArrayList<String> toolTip = new ArrayList<String>();
        int maxDurability = ToolHelper.getMaxDurability(toolTag);
        if (maxDurability > 0) {
            int curDurability = maxDurability - ToolHelper.getUsedDurability(toolTag);
            int effectiveDurability = ToolHelper.getEffectiveDurability(toolTag);
            String curOfMax = curDurability == maxDurability ? StringHelper.getDurabilityString(maxDurability) : StringHelper.getDurabilityString(curDurability) + " / " + StringHelper.getDurabilityString(maxDurability);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation2") + ColorHelper.getRelativeColor(curDurability, 0.0, maxDurability) + curOfMax);
            if (maxDurability != effectiveDurability) {
                String effectiveDurabilityTitle = StatCollector.func_74837_a((String)"tictooltips.tool.effective.durability", (Object[])new Object[]{StringHelper.getLocalizedString("gui.toolstation2")});
                String effectiveDurabilityColor = ColorHelper.getRelativeColor(ToolHelper.getReinforcedLevel(toolTag), ToolPartHelper.minReinforcedLevel - 3, ToolPartHelper.maxReinforcedLevel);
                String effectiveDurabilityValue = StringHelper.getDurabilityString(effectiveDurability);
                toolTip.add(effectiveDurabilityTitle + effectiveDurabilityColor + effectiveDurabilityValue);
            }
        }
        return toolTip;
    }

    public List<String> getAmmoCountTooltip(IAmmo ammo, NBTTagCompound toolTag, ItemStack itemStack) {
        ArrayList<String> toolTip = new ArrayList<String>();
        int maxAmmo = ammo.getMaxAmmo(itemStack);
        if (maxAmmo > 0) {
            int curAmmo = ammo.getAmmoCount(itemStack);
            String curOfMax = curAmmo == maxAmmo ? StringHelper.getAmmoCountString(maxAmmo) : StringHelper.getAmmoCountString(curAmmo) + " / " + StringHelper.getAmmoCountString(maxAmmo);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation21") + ColorHelper.getRelativeColor(curAmmo, 0.0, maxAmmo) + curOfMax);
        }
        return toolTip;
    }

    public List<String> getWeaponTooltip(ToolCore tool, NBTTagCompound toolTag) {
        return this.getWeaponTooltip(tool, toolTag, 1.0f);
    }

    public List<String> getWeaponTooltip(ToolCore tool, NBTTagCompound toolTag, float damageModifier) {
        String bonusOrLoss;
        EnumChatFormatting textColor;
        ArrayList<String> toolTip = new ArrayList<String>();
        int damage = ToolHelper.getDamage(tool, toolTag, damageModifier);
        float stoneboundDamage = ToolHelper.hasDurability((Item)tool) ? ToolHelper.getShoddinessDamageBonus(tool, toolTag) : 0.0f;
        float maxStoneboundDamage = ToolHelper.hasDurability((Item)tool) ? ToolHelper.getMaxShoddinessDamageBonus(tool, toolTag) : 0.0f;
        int[] smiteDamageRange = ToolHelper.getSmiteDamageRange(tool, toolTag);
        int[] antiSpiderDamageRange = ToolHelper.getAntiSpiderDamageRange(tool, toolTag);
        int burnDuration = ToolHelper.getBurnDuration(tool, toolTag);
        float chanceToBehead = ToolHelper.getChanceToBehead(tool, toolTag);
        float shoddiness = ToolHelper.getStonebound(toolTag);
        String shoddinessType = StringHelper.getShoddinessTypeString(shoddiness);
        String shoddinessCode = StringHelper.getShoddinessTypeCode(shoddiness);
        String bonusOrLossCode = stoneboundDamage > 0.0f ? "bonus" : "loss";
        float knockback = ToolHelper.getKnockback(tool, toolTag);
        int sprintDamage = ToolHelper.hasDurability((Item)tool) ? ToolHelper.getSprintDamage(tool, toolTag) : damage;
        String damageColor = ColorHelper.getRelativeColor((float)ToolHelper.getRawDamage(tool, toolTag) + stoneboundDamage, ToolPartHelper.minAttack, ToolPartHelper.maxAttack);
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + damageColor + StringHelper.getDamageString(damage));
        int baseDamage = ToolHelper.getBaseDamage(tool, toolTag);
        if (baseDamage >= 0) {
            String baseDamageColor = ColorHelper.getRelativeColor(baseDamage, ToolPartHelper.minAttack, ToolPartHelper.maxAttack);
            toolTip.add(StringHelper.getLocalizedString("tictooltips.tool.basedamage") + baseDamageColor + StringHelper.getDamageString(baseDamage));
        }
        if (sprintDamage != damage) {
            String sprintDamageColor = ColorHelper.getRelativeColor((float)ToolHelper.getRawDamage(tool, toolTag) + stoneboundDamage + (float)(sprintDamage - damage), ToolPartHelper.minAttack, ToolPartHelper.maxAttack);
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74838_a((String)"tictooltips.tool.sprint.damage") + sprintDamageColor + StringHelper.getDamageString(sprintDamage));
        }
        if (stoneboundDamage != 0.0f) {
            textColor = stoneboundDamage > 0.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
            bonusOrLoss = (stoneboundDamage > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5")) + textColor;
            String shoddinessBonusOrLossTitle = StatCollector.func_74837_a((String)("tictooltips.tool." + shoddinessCode + "." + bonusOrLossCode), (Object[])new Object[]{shoddinessType, bonusOrLoss});
            String maxString = "";
            if (MathHelper.equals(stoneboundDamage, maxStoneboundDamage)) {
                bonusOrLoss = bonusOrLoss + EnumChatFormatting.BOLD;
            } else {
                maxString = EnumChatFormatting.RESET + " " + EnumChatFormatting.DARK_GRAY + "[" + StatCollector.func_74838_a((String)"tictooltips.maximum") + ": " + StringHelper.getDamageNumberString((int)maxStoneboundDamage) + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GRAY + "]";
            }
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + shoddinessBonusOrLossTitle + StringHelper.getDamageString((int)stoneboundDamage) + maxString);
        } else if (!MathHelper.equals(maxStoneboundDamage, 0.0f) && !MathHelper.equals(stoneboundDamage, maxStoneboundDamage)) {
            String bonusOrLoss2 = maxStoneboundDamage > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") + EnumChatFormatting.DARK_GREEN : StringHelper.getLocalizedString("gui.toolstation5") + EnumChatFormatting.DARK_RED;
            String maxShoddinessBonusOrLossTitle = StatCollector.func_74837_a((String)("tictooltips.tool.max." + shoddinessCode + "." + bonusOrLossCode), (Object[])new Object[]{StatCollector.func_74838_a((String)"tictooltips.maximum"), shoddinessType, bonusOrLoss2});
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + maxShoddinessBonusOrLossTitle + StringHelper.getDamageString((int)maxStoneboundDamage));
        }
        if (smiteDamageRange[1] != 0 && smiteDamageRange[0] != 0) {
            textColor = smiteDamageRange[0] >= 0 ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
            bonusOrLoss = smiteDamageRange[0] >= 0 ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5");
            bonusOrLoss = bonusOrLoss.substring(0, bonusOrLoss.length() - 2);
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74837_a((String)"tictooltips.tool.bonus.vs.undead", (Object[])new Object[]{bonusOrLoss}) + textColor + StringHelper.getDamageNumberString(smiteDamageRange[0]) + "-" + StringHelper.getDamageString(smiteDamageRange[1]));
        }
        if (antiSpiderDamageRange[1] != 0 && antiSpiderDamageRange[0] != 0) {
            textColor = antiSpiderDamageRange[0] >= 0 ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
            bonusOrLoss = antiSpiderDamageRange[0] >= 0 ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5");
            bonusOrLoss = bonusOrLoss.substring(0, bonusOrLoss.length() - 2);
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74837_a((String)"tictooltips.tool.bonus.vs.spiders", (Object[])new Object[]{bonusOrLoss}) + textColor + StringHelper.getDamageNumberString(antiSpiderDamageRange[0]) + "-" + StringHelper.getDamageString(antiSpiderDamageRange[1]));
        }
        if (burnDuration != 0) {
            textColor = EnumChatFormatting.DARK_RED;
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74838_a((String)"tictooltips.tool.burn.duration") + textColor + StringHelper.getDurationString(burnDuration));
        }
        if (chanceToBehead != 0.0f) {
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74838_a((String)"tictooltips.tool.chance.to.behead") + ColorHelper.getRelativeColor(chanceToBehead, 0.0, 1.0) + StringHelper.getPercentageString(chanceToBehead));
        }
        if (knockback != 0.0f) {
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74838_a((String)"tictooltips.tool.knockback") + ColorHelper.getRelativeColor(knockback, 0.0, 3.0) + StringHelper.getKnockbackString(knockback));
        }
        return toolTip;
    }

    public List<String> getHarvestTooltip(ToolCore tool, NBTTagCompound toolTag) {
        ArrayList<String> toolTip = new ArrayList<String>();
        int mineSpeed = ToolHelper.getTotalMiningSpeed(tool, toolTag);
        float stoneboundSpeed = ToolHelper.getShoddinessSpeedBonus(tool, toolTag);
        float maxStoneboundSpeed = ToolHelper.getMaxShoddinessSpeedBonus(tool, toolTag);
        float shoddiness = ToolHelper.getStonebound(toolTag);
        String shoddinessType = StringHelper.getShoddinessTypeString(shoddiness);
        String shoddinessCode = StringHelper.getShoddinessTypeCode(shoddiness);
        String bonusOrLossCode = stoneboundSpeed > 0.0f ? "bonus" : "loss";
        mineSpeed = (int)((float)mineSpeed + stoneboundSpeed * 100.0f);
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation14") + ToolPartHelper.getMiningSpeedString(mineSpeed));
        if (stoneboundSpeed != 0.0f) {
            EnumChatFormatting textColor = stoneboundSpeed > 0.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
            String bonusOrLoss = (stoneboundSpeed > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5")) + textColor;
            String shoddinessBonusOrLossTitle = StatCollector.func_74837_a((String)("tictooltips.tool." + shoddinessCode + "." + bonusOrLossCode), (Object[])new Object[]{shoddinessType, bonusOrLoss});
            String maxString = "";
            if (MathHelper.equals(stoneboundSpeed, maxStoneboundSpeed)) {
                shoddinessBonusOrLossTitle = shoddinessBonusOrLossTitle + EnumChatFormatting.BOLD;
            } else {
                maxString = EnumChatFormatting.RESET + " " + EnumChatFormatting.DARK_GRAY + "[" + StatCollector.func_74838_a((String)"tictooltips.maximum") + ": " + StringHelper.getSpeedString((int)(maxStoneboundSpeed * 100.0f)) + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GRAY + "]";
            }
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + shoddinessBonusOrLossTitle + StringHelper.getSpeedString((int)(stoneboundSpeed * 100.0f)) + maxString);
        } else if (!MathHelper.equals(maxStoneboundSpeed, 0.0f) && !MathHelper.equals(stoneboundSpeed, maxStoneboundSpeed)) {
            String bonusOrLoss = maxStoneboundSpeed > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") + EnumChatFormatting.DARK_GREEN : StringHelper.getLocalizedString("gui.toolstation5") + EnumChatFormatting.DARK_RED;
            String maxShoddinessBonusOrLossTitle = StatCollector.func_74837_a((String)("tictooltips.tool.max." + shoddinessCode + "." + bonusOrLossCode), (Object[])new Object[]{StatCollector.func_74838_a((String)"tictooltips.maximum"), shoddinessType, bonusOrLoss});
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + maxShoddinessBonusOrLossTitle + StringHelper.getSpeedString((int)(maxStoneboundSpeed * 100.0f)));
        }
        if (!ModTiCTooltips.hasIguanaTweaks) {
            int harvestLevel = ToolHelper.getPrimaryHarvestLevel(toolTag);
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation15") + ToolPartHelper.getHarvestLevelString(harvestLevel));
        }
        return toolTip;
    }

    public List<String> getDualHarvestTooltip(ToolCore tool, NBTTagCompound toolTag) {
        ArrayList<String> toolTip = new ArrayList<String>();
        int mineSpeed1 = ToolHelper.getPrimaryMiningSpeed(tool, toolTag);
        int mineSpeed2 = ToolHelper.getSecondaryMiningSpeed(tool, toolTag);
        float stoneboundSpeed = ToolHelper.getShoddinessSpeedBonus(tool, toolTag);
        float maxStoneboundSpeed = ToolHelper.getMaxShoddinessSpeedBonus(tool, toolTag);
        float shoddiness = ToolHelper.getStonebound(toolTag);
        String shoddinessType = StringHelper.getShoddinessTypeString(shoddiness);
        String shoddinessCode = StringHelper.getShoddinessTypeCode(shoddiness);
        String bonusOrLossCode = stoneboundSpeed > 0.0f ? "bonus" : "loss";
        mineSpeed1 = (int)((float)mineSpeed1 + stoneboundSpeed * 100.0f);
        mineSpeed2 = (int)((float)mineSpeed2 + stoneboundSpeed * 100.0f);
        int harvestLevel1 = ToolHelper.getPrimaryHarvestLevel(toolTag);
        int harvestLevel2 = ToolHelper.getSecondaryHarvestLevel(toolTag);
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation12") + ToolPartHelper.getMiningSpeedString(mineSpeed1) + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + ", " + ToolPartHelper.getMiningSpeedString(mineSpeed2));
        if (stoneboundSpeed != 0.0f) {
            EnumChatFormatting textColor = stoneboundSpeed > 0.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
            String bonusOrLoss = (stoneboundSpeed > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5")) + textColor;
            String shoddinessBonusOrLossTitle = StatCollector.func_74837_a((String)("tictooltips.tool." + shoddinessCode + "." + bonusOrLossCode), (Object[])new Object[]{shoddinessType, bonusOrLoss});
            String maxString = "";
            if (MathHelper.equals(stoneboundSpeed, maxStoneboundSpeed)) {
                shoddinessBonusOrLossTitle = shoddinessBonusOrLossTitle + EnumChatFormatting.BOLD;
            } else {
                maxString = EnumChatFormatting.RESET + " " + EnumChatFormatting.DARK_GRAY + "[" + StatCollector.func_74838_a((String)"tictooltips.maximum") + ": " + StringHelper.getSpeedString((int)(maxStoneboundSpeed * 100.0f)) + EnumChatFormatting.RESET + EnumChatFormatting.DARK_GRAY + "]";
            }
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + shoddinessBonusOrLossTitle + StringHelper.getSpeedString((int)(stoneboundSpeed * 100.0f)) + maxString);
        } else if (!MathHelper.equals(maxStoneboundSpeed, 0.0f) && !MathHelper.equals(stoneboundSpeed, maxStoneboundSpeed)) {
            String bonusOrLoss = maxStoneboundSpeed > 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") + EnumChatFormatting.DARK_GREEN : StringHelper.getLocalizedString("gui.toolstation5") + EnumChatFormatting.DARK_RED;
            String maxShoddinessBonusOrLossTitle = StatCollector.func_74837_a((String)("tictooltips.tool.max." + shoddinessCode + "." + bonusOrLossCode), (Object[])new Object[]{StatCollector.func_74838_a((String)"tictooltips.maximum"), shoddinessType, bonusOrLoss});
            toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + maxShoddinessBonusOrLossTitle + StringHelper.getSpeedString((int)(maxStoneboundSpeed * 100.0f)));
        }
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation13") + " " + ToolPartHelper.getHarvestLevelString(harvestLevel1) + EnumChatFormatting.RESET + EnumChatFormatting.GRAY + ", " + ToolPartHelper.getHarvestLevelString(harvestLevel2));
        return toolTip;
    }

    public List<String> getShoddinessTooltip(ToolCore tool, NBTTagCompound toolTag) {
        boolean isShoddy;
        ArrayList<String> toolTip = new ArrayList<String>();
        float shoddiness = ToolHelper.getStonebound(toolTag);
        boolean bl = isShoddy = shoddiness != 0.0f;
        if (isShoddy) {
            String shoddinessModifierTitle;
            String shoddinessCode = StringHelper.getShoddinessTypeCode(shoddiness);
            if (StatCollector.func_94522_b((String)("tictooltips.tool." + shoddinessCode + ".modifier"))) {
                shoddinessModifierTitle = StatCollector.func_74838_a((String)("tictooltips.tool." + shoddinessCode + ".modifier"));
            } else {
                String shoddinessType = StringHelper.getShoddinessTypeString(shoddiness);
                shoddinessModifierTitle = StatCollector.func_74837_a((String)"tictooltips.tool.shoddiness.modifier", (Object[])new Object[]{shoddinessType});
            }
            toolTip.add(shoddinessModifierTitle + ToolPartHelper.getShoddinessString(shoddiness));
        }
        return toolTip;
    }

    public List<String> getBowTooltip(ToolCore tool, NBTTagCompound toolTag, ItemStack itemStack) {
        ProjectileWeapon projectileWeapon;
        ItemStack currentAmmo;
        ArrayList<String> toolTip = new ArrayList<String>();
        if (itemStack != null && tool instanceof ProjectileWeapon && (currentAmmo = (projectileWeapon = (ProjectileWeapon)tool).searchForAmmo((EntityPlayer)FMLClientHandler.instance().getClientPlayerEntity(), itemStack)) != null) {
            if (ToolHelper.hasToolTag(currentAmmo) && currentAmmo.func_77973_b() instanceof ToolCore) {
                toolTip.addAll(this.getWeaponTooltip((ToolCore)currentAmmo.func_77973_b(), ToolHelper.getToolTag(currentAmmo), projectileWeapon.getProjectileSpeed(itemStack)));
                float[] critDamageRange = ToolHelper.getCriticalDamageRange((ToolCore)currentAmmo.func_77973_b(), ToolHelper.getToolTag(currentAmmo), projectileWeapon.getProjectileSpeed(itemStack));
                if (critDamageRange[1] != 0.0f) {
                    EnumChatFormatting textColor = critDamageRange[0] >= 0.0f ? EnumChatFormatting.DARK_GREEN : EnumChatFormatting.DARK_RED;
                    String bonusOrLoss = critDamageRange[0] >= 0.0f ? StringHelper.getLocalizedString("gui.toolstation4") : StringHelper.getLocalizedString("gui.toolstation5");
                    bonusOrLoss = bonusOrLoss.substring(0, bonusOrLoss.length() - 2);
                    toolTip.add(EnumChatFormatting.DARK_GRAY + "- " + StatCollector.func_74837_a((String)"tictooltips.tool.crit.damage", (Object[])new Object[]{bonusOrLoss}) + textColor + StringHelper.getDamageNumberString(critDamageRange[0]) + "-" + StringHelper.getDamageString(critDamageRange[1]));
                }
            } else if (currentAmmo.func_77973_b() == Items.field_151032_g) {
                int damage = (int)(2.0f * projectileWeapon.getProjectileSpeed(itemStack));
                toolTip.add(StringHelper.getLocalizedString("gui.toolstation3") + ColorHelper.getRelativeColor(damage, ToolPartHelper.minAttack, ToolPartHelper.maxAttack) + StringHelper.getDamageString(damage));
            }
        }
        int drawSpeed = ToolHelper.getDrawSpeed(tool, toolTag);
        float arrowSpeed = ToolHelper.getArrowSpeed(tool, toolTag);
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation6") + ToolPartHelper.getBowDrawSpeedString(drawSpeed));
        if (tool instanceof Crossbow || tool instanceof LongBow) {
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation7") + ToolPartHelper.getArrowSpeedString(arrowSpeed, 1.5f));
        } else {
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation7") + ToolPartHelper.getArrowSpeedString(arrowSpeed));
        }
        return toolTip;
    }

    public List<String> getAmmoTooltip(ToolCore tool, NBTTagCompound toolTag) {
        ArrayList<String> toolTip = new ArrayList<String>();
        return toolTip;
    }

    public List<String> getUtilityTooltip(ToolCore tool, NBTTagCompound toolTag) {
        ArrayList<String> toolTip = new ArrayList<String>();
        int mineSpeed = ToolHelper.getPrimaryMiningSpeed(tool, toolTag);
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation16") + ToolPartHelper.getMiningSpeedString(mineSpeed));
        return toolTip;
    }

    public List<String> getThrownTooltip(ToolCore tool, NBTTagCompound toolTag) {
        ArrayList<String> toolTip = new ArrayList<String>();
        return toolTip;
    }

    public List<String> getProjectileTooltip(ToolCore tool, NBTTagCompound toolTag) {
        ArrayList<String> toolTip = new ArrayList<String>();
        float weight = ToolHelper.getWeight(toolTag);
        float accuracy = ToolHelper.getAccuracy(toolTag);
        float breakChance = ToolHelper.getBreakChance(toolTag);
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation8") + ToolPartHelper.getWeightString(weight));
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation9") + ToolPartHelper.getAccuracyString(accuracy));
        toolTip.add(StringHelper.getLocalizedString("gui.toolstation22") + ToolPartHelper.getBreakChanceString(breakChance));
        return toolTip;
    }

    public List<String> getModifiersTooltip(ToolCore tool, NBTTagCompound toolTag) {
        ArrayList<String> toolTip = new ArrayList<String>();
        int modifiersAvailable = toolTag.func_74762_e("Modifiers");
        if (modifiersAvailable > 0) {
            toolTip.add(StringHelper.getLocalizedString("gui.toolstation18") + EnumChatFormatting.WHITE + modifiersAvailable);
        }
        ArrayList<String> modifierToolTips = new ArrayList<String>();
        int tipNum = 1;
        while (toolTag.func_74764_b("ModifierTip" + tipNum)) {
            String tipName = toolTag.func_74779_i("ModifierTip" + tipNum);
            String locString = "modifier.toolstation." + tipName;
            int bracket = tipName.indexOf("(");
            if (bracket > 0) {
                locString = "modifier.toolstation." + tipName.substring(0, bracket);
            }
            if (StatCollector.func_94522_b((String)(locString = EnumChatFormatting.func_110646_a((String)locString.replace(" ", ""))))) {
                tipName = tipName.replace(EnumChatFormatting.func_110646_a((String)tipName), StatCollector.func_74838_a((String)locString));
                if (bracket > 0) {
                    tipName = tipName + " " + toolTag.func_74779_i("ModifierTip" + tipNum).substring(bracket);
                }
            }
            if (!tipName.trim().equals("")) {
                modifierToolTips.add(EnumChatFormatting.DARK_GRAY + "- " + tipName);
            }
            ++tipNum;
        }
        if (!modifierToolTips.isEmpty()) {
            toolTip.add(StatCollector.func_74838_a((String)"gui.toolstation17") + ":");
            toolTip.addAll(modifierToolTips);
        }
        return toolTip;
    }

    public List<String> getRepairTooltip(ToolCore tool, NBTTagCompound toolTag) {
        ArrayList<String> toolTip = new ArrayList<String>();
        ToolMaterial repairMat = ToolHelper.getHeadMaterial(toolTag);
        if (repairMat != null) {
            toolTip.add(StatCollector.func_74838_a((String)"tictooltips.tool.repair.material") + repairMat.style() + CompatibilityHelper.getLocalizedName(repairMat));
        }
        return toolTip;
    }

    private List<String> getToolStatsTooltip(ItemStack itemStack) {
        ArrayList<String> toolTip = new ArrayList<String>();
        ToolCore tool = (ToolCore)itemStack.func_77973_b();
        NBTTagCompound toolTag = ToolHelper.getToolTag(itemStack);
        toolTip.addAll(this.getRepairTooltip(tool, toolTag));
        if (ToolHelper.hasAmmoCount((Item)tool)) {
            toolTip.addAll(this.getAmmoCountTooltip((IAmmo)tool, toolTag, itemStack));
        } else if (ToolHelper.hasDurability((Item)tool)) {
            toolTip.addAll(this.getDurabilityTooltip(toolTag, itemStack));
            toolTip.addAll(this.getShoddinessTooltip(tool, toolTag));
        }
        if (ToolHelper.isBow(tool)) {
            toolTip.addAll(this.getBowTooltip(tool, toolTag, itemStack));
        } else if (ToolHelper.isWeapon(tool)) {
            toolTip.addAll(this.getWeaponTooltip(tool, toolTag));
        }
        if (ToolHelper.isThrown(tool)) {
            toolTip.addAll(this.getThrownTooltip(tool, toolTag));
        }
        if (ToolHelper.isAmmo(tool)) {
            toolTip.addAll(this.getAmmoTooltip(tool, toolTag));
        }
        if (ToolHelper.isProjectile(tool)) {
            toolTip.addAll(this.getProjectileTooltip(tool, toolTag));
        }
        if (ToolHelper.isDualHarvestTool(tool)) {
            toolTip.addAll(this.getDualHarvestTooltip(tool, toolTag));
        } else if (ToolHelper.isHarvestTool(tool)) {
            toolTip.addAll(this.getHarvestTooltip(tool, toolTag));
        } else if (ToolHelper.isUtilityTool(tool)) {
            toolTip.addAll(this.getUtilityTooltip(tool, toolTag));
        }
        toolTip.addAll(this.getModifiersTooltip(tool, toolTag));
        return toolTip;
    }

    private List<String> getToolMaterialsTooltip(ItemStack itemStack) {
        int matID;
        ArrayList<String> toolTip = new ArrayList<String>();
        ToolCore tool = (ToolCore)itemStack.func_77973_b();
        NBTTagCompound toolTag = ToolHelper.getToolTag(itemStack);
        Item itemPart = tool.getHeadItem();
        if (itemPart != null) {
            matID = toolTag.func_74762_e("Head");
            toolTip.addAll(this.getToolPartTooltip(itemPart, matID, tool));
            toolTip.add("");
        }
        if ((itemPart = tool.getAccessoryItem()) != null) {
            matID = toolTag.func_74762_e("Accessory");
            toolTip.addAll(this.getToolPartTooltip(itemPart, matID, tool));
            toolTip.add("");
        }
        if ((itemPart = tool.getExtraItem()) != null) {
            matID = toolTag.func_74762_e("Extra");
            toolTip.addAll(this.getToolPartTooltip(itemPart, matID, tool));
            toolTip.add("");
        }
        if ((itemPart = tool.getHandleItem()) != null) {
            matID = toolTag.func_74762_e("Handle");
            toolTip.addAll(this.getToolPartTooltip(itemPart, matID, tool));
        }
        return toolTip;
    }

    private List<String> getToolPartTooltip(Item itemPart, int matID, ToolCore tool) {
        ArrayList<String> toolTip = new ArrayList<String>();
        if (ProxyExtraTiC.isExtraTiCMaterialID(matID)) {
            itemPart = ProxyExtraTiC.ticToExtraTiCParts.get(itemPart);
        }
        String matStyle = "";
        if (!ToolPartHelper.hasCustomMaterial(itemPart)) {
            ToolMaterial mat = TConstructRegistry.getMaterial((int)matID);
            matStyle = mat != null ? mat.style() : "";
        }
        ItemStack tempStack = new ItemStack(itemPart, 1, matID);
        toolTip.add(matStyle + EnumChatFormatting.UNDERLINE + tempStack.func_82833_r());
        List<String> partStats = this.getMaterialTooltip(matID, itemPart, tool);
        toolTip.addAll(partStats);
        return toolTip;
    }
}

