/*
 * Decompiled with CFR 0.152.
 */
package glowredman.txloader;

import glowredman.txloader.RemoteHandler;
import glowredman.txloader.TXLoaderCore;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;

class Asset {
    String resourceLocation;
    String resourceLocationOverride;
    boolean forceLoad;
    String version;
    Source source;
    transient boolean addedByMod;

    Asset(String resourceLocation, String version, Source source) {
        this.resourceLocation = resourceLocation;
        this.version = version;
        this.source = source;
    }

    String getResourceLocation() {
        return this.resourceLocationOverride == null ? this.resourceLocation : this.resourceLocationOverride;
    }

    File getFile() {
        File path = this.forceLoad ? TXLoaderCore.forceResourcesDir : TXLoaderCore.resourcesDir;
        return new File(path, this.getResourceLocation());
    }

    String getVersion() {
        return this.version == null ? RemoteHandler.latestRelease : this.version;
    }

    Source getSource() {
        return this.source == null ? Source.ASSET : this.source;
    }

    static enum Source {
        ASSET,
        CLIENT,
        SERVER;

        static final Iterable<String> NAMES;

        static Source get(String name) {
            try {
                return Source.valueOf(name);
            }
            catch (Exception e) {
                TXLoaderCore.LOGGER.warn("{} is not a valid source identifier!", new Object[]{name});
                return ASSET;
            }
        }

        static {
            NAMES = Arrays.stream(Source.values()).map(Enum::name).collect(Collectors.toList());
        }
    }
}

