/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.IPipeServiceProvider;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.modules.abstractmodules.LogisticsGuiModule;
import logisticspipes.modules.abstractmodules.LogisticsModule;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.network.guis.pipe.ChassiGuiProvider;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.proxy.computers.objects.CCSinkResponder;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ChassiModule
extends LogisticsGuiModule {
    private final LogisticsModule[] _modules;
    private final PipeLogisticsChassi _parentPipe;

    public ChassiModule(int moduleCount, PipeLogisticsChassi parentPipe) {
        this._modules = new LogisticsModule[moduleCount];
        this._parentPipe = parentPipe;
        this._service = parentPipe;
        this.registerPosition(LogisticsModule.ModulePositionType.IN_PIPE, 0);
    }

    public void installModule(int slot, LogisticsModule module) {
        this._modules[slot] = module;
    }

    public void removeModule(int slot) {
        this._modules[slot] = null;
    }

    public LogisticsModule getModule(int slot) {
        return this._modules[slot];
    }

    public boolean hasModule(int slot) {
        return this._modules[slot] != null;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority, boolean allowDefault, boolean includeInTransit) {
        SinkReply bestresult = null;
        for (LogisticsModule module : this._modules) {
            SinkReply result;
            if (module == null || (result = module.sinksItem(item, bestPriority, bestCustomPriority, allowDefault, includeInTransit)) == null || result.maxNumberOfItems < 0) continue;
            bestresult = result;
            bestPriority = result.fixedPriority.ordinal();
            bestCustomPriority = result.customPriority;
        }
        if (bestresult == null) {
            return null;
        }
        IInventoryUtil invUtil = this._parentPipe.getSneakyInventory(false, LogisticsModule.ModulePositionType.SLOT, ((PipeLogisticsChassi.ChassiTargetInformation)bestresult.addInfo).getModuleSlot());
        if (invUtil == null) {
            return null;
        }
        int roomForItem = invUtil.roomForItem(item);
        if (roomForItem < 1) {
            return null;
        }
        if (includeInTransit) {
            int onRoute = this._parentPipe.countOnRoute(item);
            roomForItem = invUtil.roomForItem(item, onRoute + item.getMaxStackSize());
            if ((roomForItem -= onRoute) < 1) {
                return null;
            }
        }
        if (bestresult.maxNumberOfItems == 0) {
            return new SinkReply(bestresult, roomForItem);
        }
        return new SinkReply(bestresult, Math.min(bestresult.maxNumberOfItems, roomForItem));
    }

    @Override
    public LogisticsModule getSubModule(int slot) {
        if (slot < 0 || slot >= this._modules.length) {
            return null;
        }
        return this._modules[slot];
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this._modules.length; ++i) {
            NBTTagCompound slot;
            if (this._modules[i] == null || (slot = nbttagcompound.func_74775_l("slot" + i)) == null) continue;
            this._modules[i].readFromNBT(slot);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        for (int i = 0; i < this._modules.length; ++i) {
            if (this._modules[i] == null) continue;
            NBTTagCompound slot = new NBTTagCompound();
            this._modules[i].writeToNBT(slot);
            nbttagcompound.func_74782_a("slot" + i, (NBTBase)slot);
        }
    }

    @Override
    public void tick() {
        for (LogisticsModule module : this._modules) {
            if (module == null) continue;
            module.tick();
        }
    }

    @Override
    public void registerHandler(IWorldProvider world, IPipeServiceProvider service) {
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    public List<ItemIdentifier> getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        for (LogisticsModule module : this._modules) {
            if (module == null || !module.recievePassive()) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<CCSinkResponder> queueCCSinkEvent(ItemIdentifierStack item) {
        ArrayList<CCSinkResponder> list = new ArrayList<CCSinkResponder>();
        for (LogisticsModule module : this._modules) {
            if (module == null) continue;
            list.addAll(module.queueCCSinkEvent(item));
        }
        return list;
    }

    @Override
    public IIcon getIconTexture(IIconRegister register) {
        return null;
    }

    @Override
    protected ModuleCoordinatesGuiProvider getPipeGuiProvider() {
        return NewGuiHandler.getGui(ChassiGuiProvider.class).setFlag(this._parentPipe.getUpgradeManager().hasUpgradeModuleUpgrade());
    }

    @Override
    protected ModuleInHandGuiProvider getInHandGuiProvider() {
        return null;
    }
}

