/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.tablet.utils;

import buildcraft.api.tablet.TabletBitmap;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class TabletFont {
    private boolean isBold;
    private boolean isItalic;
    private int pointSize;
    private int maxW;
    private int maxH;
    private int ascent;
    private int descent;
    private TIntObjectMap<Glyph> glyphs = new TIntObjectHashMap();

    public TabletFont(File file) throws Exception {
        this(new FileInputStream(file));
    }

    public TabletFont(InputStream stream) throws Exception {
        int loaded = 0;
        while (stream.available() > 0) {
            String section = TabletFont.readString(stream, 4);
            int sectionLength = TabletFont.readInt(stream);
            loaded += 8;
            if ("FAMI".equals(section)) {
                TabletFont.readString(stream, sectionLength);
            } else if ("WEIG".equals(section)) {
                this.isBold = "bold".equals(TabletFont.readString(stream, sectionLength));
            } else if ("SLAN".equals(section)) {
                this.isItalic = "italic".equals(TabletFont.readString(stream, sectionLength));
            } else if ("PTSZ".equals(section)) {
                this.pointSize = TabletFont.readUnsignedShort(stream);
            } else if ("MAXW".equals(section)) {
                this.maxW = TabletFont.readUnsignedShort(stream);
            } else if ("MAXH".equals(section)) {
                this.maxH = TabletFont.readUnsignedShort(stream);
            } else if ("ASCE".equals(section)) {
                this.ascent = TabletFont.readUnsignedShort(stream);
            } else if ("DESC".equals(section)) {
                this.descent = TabletFont.readUnsignedShort(stream);
            } else if ("CHIX".equals(section)) {
                for (int i = 0; i < sectionLength; i += 9) {
                    int codePoint = TabletFont.readInt(stream);
                    stream.skip(1L);
                    int offset = TabletFont.readInt(stream);
                    this.glyphs.put(codePoint, (Object)new Glyph(offset));
                }
            } else if ("DATA".equals(section)) {
                byte[] data = new byte[stream.available()];
                stream.read(data);
                for (Glyph g : this.glyphs.valueCollection()) {
                    g.load(data, loaded);
                }
            } else {
                stream.skip(sectionLength);
            }
            loaded += sectionLength;
        }
        stream.close();
    }

    public boolean isBold() {
        return this.isBold;
    }

    public boolean isItalic() {
        return this.isItalic;
    }

    public int getPointSize() {
        return this.pointSize;
    }

    public int getWidth() {
        return this.maxW;
    }

    public int getHeight() {
        return this.maxH;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public Glyph getGlyph(int codePoint) {
        return (Glyph)this.glyphs.get(codePoint);
    }

    public int getStringWidth(String s) {
        int width = 0;
        for (int i = 0; i < s.length(); ++i) {
            width += this.getGlyph(s.codePointAt(i)).getDeviceWidth();
        }
        return width;
    }

    public int draw(TabletBitmap target, String s, int x, int y, int intensity) {
        int width = 0;
        for (int i = 0; i < s.length(); ++i) {
            width += this.getGlyph(s.codePointAt(i)).draw(target, x + width, y + this.ascent, intensity);
        }
        return width;
    }

    private static int readUnsignedShort(InputStream stream) {
        try {
            int hi = stream.read();
            return hi << 8 | stream.read();
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static int readShort(InputStream stream) {
        int t = TabletFont.readUnsignedShort(stream);
        if (t >= 32768) {
            return 0 - (t ^ 0xFFFF);
        }
        return t;
    }

    private static int readInt(InputStream stream) {
        try {
            int i = stream.read();
            i = i << 8 | stream.read();
            i = i << 8 | stream.read();
            i = i << 8 | stream.read();
            return i;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
    }

    private static String readString(InputStream stream, int length) {
        byte[] data = new byte[length];
        try {
            stream.read(data);
            return new String(data, "ASCII");
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static void main(String[] args) {
        TabletBitmap bitmap = new TabletBitmap(244, 306);
        try {
            TabletFont font = new TabletFont(TabletFont.class.getClassLoader().getResourceAsStream("assets/buildcraftcore/tablet/test.pf2"));
            font.draw(bitmap, "Hello World!", 1, 1, 4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final class Glyph {
        public byte[] glyphData;
        private final int loadOffset;
        private int width;
        private int height;
        private int xOffset;
        private int yOffset;
        private int deviceWidth;

        public Glyph(int offset) {
            this.loadOffset = offset;
        }

        public void load(byte[] data, int offsetBase) throws Exception {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            stream.skip(this.loadOffset - offsetBase);
            this.width = TabletFont.readUnsignedShort(stream);
            this.height = TabletFont.readUnsignedShort(stream);
            this.xOffset = TabletFont.readShort(stream);
            this.yOffset = TabletFont.readShort(stream);
            this.deviceWidth = TabletFont.readShort(stream);
            this.glyphData = new byte[(this.width * this.height + 7) / 8];
            stream.read(this.glyphData);
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int getDeviceWidth() {
            return this.deviceWidth;
        }

        public int getXOffset() {
            return this.xOffset;
        }

        public int getYOffset() {
            return this.yOffset;
        }

        public int draw(TabletBitmap bitmap, int x, int y, int intensity) {
            int yTop = y - this.yOffset * 2 - this.height;
            for (int j = 0; j < this.height; ++j) {
                for (int i = 0; i < this.width; ++i) {
                    int bPos = i + j * this.width >> 3;
                    int bMask = 128 >> (i + j * this.width & 7);
                    if ((this.glyphData[bPos] & bMask) == 0) continue;
                    bitmap.set(x + this.xOffset + i, yTop + j, intensity);
                }
            }
            return this.deviceWidth;
        }
    }
}

