/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.tools.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mantle.items.abstracts.CraftingItem;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.PatternBuilder;
import tconstruct.library.util.IPattern;

public class Pattern
extends CraftingItem
implements IPattern {
    private static final String[] patternName = new String[]{"ingot", "rod", "pickaxe", "shovel", "axe", "swordblade", "largeguard", "mediumguard", "crossbar", "binding", "frypan", "sign", "knifeblade", "chisel", "largerod", "toughbinding", "largeplate", "broadaxe", "scythe", "excavator", "largeblade", "hammerhead", "fullguard", "bowstring", "fletching", "arrowhead"};
    private static final Map<Integer, Integer> patternCosts = Pattern.buildPatternCostMap();

    public Pattern(String patternType, String folder) {
        this(patternName, Pattern.getPatternNames(patternType), folder);
    }

    public Pattern(String[] names, String[] patternTypes, String folder) {
        super(names, patternTypes, folder, "tinker", (CreativeTabs)TConstructRegistry.materialTab);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77642_a((Item)this);
        this.func_77625_d(1);
    }

    protected static String[] getPatternNames(String partType) {
        String[] names = new String[patternName.length];
        for (int i = 0; i < patternName.length; ++i) {
            names[i] = partType + patternName[i];
        }
        return names;
    }

    public void func_150895_a(Item b, CreativeTabs tab, List list) {
        for (int i = 1; i < patternName.length; ++i) {
            list.add(new ItemStack(b, 1, i));
        }
    }

    private static Map<Integer, Integer> buildPatternCostMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(0, 2);
        map.put(1, 1);
        map.put(2, 2);
        map.put(3, 2);
        map.put(4, 2);
        map.put(5, 2);
        map.put(6, 1);
        map.put(7, 1);
        map.put(8, 1);
        map.put(9, 1);
        map.put(10, 2);
        map.put(11, 2);
        map.put(12, 1);
        map.put(13, 1);
        map.put(14, 6);
        map.put(15, 6);
        map.put(16, 16);
        map.put(17, 16);
        map.put(18, 16);
        map.put(19, 16);
        map.put(20, 16);
        map.put(21, 16);
        map.put(22, 6);
        map.put(23, 6);
        map.put(24, 2);
        map.put(25, 2);
        return map;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        if (stack.field_77994_a <= 0) {
            return null;
        }
        return stack;
    }

    public boolean func_77630_h(ItemStack stack) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        float cost = (float)this.getPatternCost(stack) / 2.0f;
        if (cost > 0.0f) {
            if ((double)(cost - (float)((int)cost)) < 0.1) {
                list.add(StatCollector.func_74838_a((String)"pattern1.tooltip") + (int)cost);
            } else {
                list.add(StatCollector.func_74838_a((String)"pattern2.tooltip") + cost);
            }
        }
    }

    public static Map<Integer, Integer> getPatternCosts() {
        return patternCosts;
    }

    public static void setPatternCost(Integer index, Integer newCost) {
        if (patternCosts.containsKey(index)) {
            patternCosts.put(index, newCost);
        }
    }

    @Override
    public int getPatternCost(ItemStack pattern) {
        return patternCosts.getOrDefault(pattern.func_77960_j(), 0);
    }

    @Override
    public ItemStack getPatternOutput(ItemStack stack, ItemStack input, PatternBuilder.MaterialSet set) {
        return TConstructRegistry.getPartMapping((Item)this, stack.func_77960_j(), set.materialID);
    }
}

