/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.client.gui;

import appeng.api.storage.ITerminalHost;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiTabButton;
import appeng.client.gui.widgets.IDropToFillTextField;
import appeng.client.gui.widgets.MEGuiTextField;
import appeng.core.localization.GuiColors;
import appeng.core.localization.GuiText;
import com.glodblock.github.FluidCraft;
import com.glodblock.github.client.gui.container.ContainerRenamer;
import com.glodblock.github.common.item.ItemWirelessUltraTerminal;
import com.glodblock.github.common.parts.PartLevelTerminal;
import com.glodblock.github.inventory.InventoryHandler;
import com.glodblock.github.inventory.gui.GuiType;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.inventory.item.WirelessInterfaceTerminalInventory;
import com.glodblock.github.inventory.item.WirelessLevelTerminalInventory;
import com.glodblock.github.loader.ItemAndBlockHolder;
import com.glodblock.github.network.CPacketRenamer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class GuiRenamer
extends AEBaseGui
implements IDropToFillTextField {
    protected final MEGuiTextField textField;
    protected final ITerminalHost host;
    protected GuiTabButton originalGuiBtn;
    protected ItemStack icon = null;

    public GuiRenamer(InventoryPlayer ip, ITerminalHost monitorable) {
        super((Container)new ContainerRenamer(ip, monitorable));
        this.host = monitorable;
        this.field_146999_f = 256;
        this.textField = new MEGuiTextField(230, 12);
        this.textField.setMaxStringLength(32);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        FluidCraft.proxy.netHandler.sendToServer(new CPacketRenamer(CPacketRenamer.Action.GET_TEXT));
        if (this.host instanceof PartLevelTerminal) {
            this.icon = ItemAndBlockHolder.LEVEL_TERMINAL.stack();
        } else {
            IWirelessTerminal terminal;
            ITerminalHost iTerminalHost = this.host;
            if (iTerminalHost instanceof IWirelessTerminal && (terminal = (IWirelessTerminal)iTerminalHost).isUniversal(this.host)) {
                this.icon = ItemAndBlockHolder.WIRELESS_ULTRA_TERM.stack();
            } else if (this.host instanceof WirelessLevelTerminalInventory) {
                this.icon = ItemAndBlockHolder.WIRELESS_LEVEL_TERM.stack();
            } else if (this.host instanceof WirelessInterfaceTerminalInventory) {
                this.icon = ItemAndBlockHolder.WIRELESS_INTERFACE_TERM.stack();
            }
        }
        if (this.icon != null) {
            this.originalGuiBtn = new GuiTabButton(this.field_147003_i + 231, this.field_147009_r - 4, this.icon, this.icon.func_82833_r(), field_146296_j);
            this.field_146292_n.add(this.originalGuiBtn);
            this.originalGuiBtn.setHideEdge(13);
        }
        this.textField.x = this.field_147003_i + 12;
        this.textField.y = this.field_147009_r + 35;
        this.textField.setFocused(true);
    }

    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(GuiText.Renamer.getLocal(), 12, 8, GuiColors.RenamerTitle.getColor());
    }

    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.bindTexture("guis/renamer.png");
        this.func_73729_b(offsetX, offsetY, 0, 0, this.field_146999_f, this.field_147000_g);
        this.textField.drawTextBox();
    }

    protected void func_73864_a(int xCoord, int yCoord, int btn) {
        this.textField.mouseClicked(xCoord, yCoord, btn);
        super.func_73864_a(xCoord, yCoord, btn);
    }

    protected void func_73869_a(char character, int key) {
        if (key == 28 || key == 156) {
            FluidCraft.proxy.netHandler.sendToServer(new CPacketRenamer(this.textField.getText()));
        } else if (!this.textField.textboxKeyTyped(character, key)) {
            super.func_73869_a(character, key);
        }
    }

    public boolean isOverTextField(int mousex, int mousey) {
        return this.textField.isMouseIn(mousex, mousey);
    }

    protected void func_146284_a(GuiButton button) {
        if (button == this.originalGuiBtn) {
            this.switchGui();
        } else {
            super.func_146284_a(button);
        }
    }

    public void switchGui() {
        if (this.host instanceof PartLevelTerminal) {
            InventoryHandler.switchGui(GuiType.LEVEL_TERMINAL);
        } else {
            IWirelessTerminal terminal;
            ITerminalHost iTerminalHost = this.host;
            if (iTerminalHost instanceof IWirelessTerminal && (terminal = (IWirelessTerminal)iTerminalHost).isUniversal(this.host)) {
                InventoryHandler.switchGui(ItemWirelessUltraTerminal.readMode(terminal.getItemStack()));
            } else if (this.host instanceof WirelessInterfaceTerminalInventory) {
                InventoryHandler.switchGui(GuiType.WIRELESS_INTERFACE_TERMINAL);
            } else if (this.host instanceof WirelessLevelTerminalInventory) {
                InventoryHandler.switchGui(GuiType.WIRELESS_LEVEL_TERMINAL);
            }
        }
    }

    public void setTextFieldValue(String displayName, int mousex, int mousey, ItemStack stack) {
        this.textField.setText(displayName);
    }

    public void postUpdate(String text) {
        this.textField.setText(text);
    }
}

