/*
 * Decompiled with CFR 0.152.
 */
package com.detrav.gui.textures;

import com.detrav.net.ProspectingPacket;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import org.lwjgl.opengl.GL11;

public class DetravMapTexture
extends AbstractTexture {
    public final ProspectingPacket packet;
    private String selected = "All";
    public int width = -1;
    public int height = -1;
    public boolean invert = false;

    public DetravMapTexture(ProspectingPacket aPacket) {
        this.packet = aPacket;
    }

    private BufferedImage getImage() {
        int backgroundColor = this.invert ? Color.GRAY.getRGB() : Color.WHITE.getRGB();
        int wh = (this.packet.size * 2 + 1) * 16;
        BufferedImage image = new BufferedImage(wh, wh, 2);
        WritableRaster raster = image.getRaster();
        int playerI = this.packet.posX - (this.packet.chunkX - this.packet.size) * 16 - 1;
        int playerJ = this.packet.posZ - (this.packet.chunkZ - this.packet.size) * 16 - 1;
        for (int i = 0; i < wh; ++i) {
            for (int j = 0; j < wh; ++j) {
                image.setRGB(i, j, backgroundColor);
                if (this.packet.map[i][j] != null) {
                    String name;
                    if (this.packet.ptype == 0 || this.packet.ptype == 1) {
                        for (short meta : this.packet.map[i][j].values()) {
                            name = this.packet.metaMap.get(meta);
                            if (!this.selected.equals("All") && !this.selected.equals(name)) continue;
                            image.setRGB(i, j, (int)(this.packet.ores.getOrDefault(name, Color.BLACK.getRGB()) | 0xFF000000));
                            break;
                        }
                    } else if (this.packet.ptype == 2) {
                        short fluidId = this.packet.map[i][j].get((byte)1);
                        short fluidSize = this.packet.map[i][j].get((byte)2);
                        name = this.packet.metaMap.get(fluidId);
                        int k = i % 16;
                        int l = j % 16;
                        if ((k + l * 16) * 3 < fluidSize + 48 && (this.selected.equals("All") || this.selected.equals(name))) {
                            image.setRGB(i, j, (int)(this.packet.ores.getOrDefault(name, Color.BLACK.getRGB()) | 0xFF000000));
                        }
                    } else if (this.packet.ptype == 3) {
                        short meta = this.packet.map[i][j].get((byte)1);
                        image.setRGB(i, j, ((meta & 0xFF) << 16) + ((meta & 0xFF) << 8) + (meta & 0xFF) | 0xFF000000);
                    }
                }
                if (i == playerI || j == playerJ) {
                    raster.setSample(i, j, 0, (raster.getSample(i, j, 0) + 255) / 2);
                    raster.setSample(i, j, 1, raster.getSample(i, j, 1) / 2);
                    raster.setSample(i, j, 2, raster.getSample(i, j, 2) / 2);
                }
                if (i % 16 != 0 && j % 16 != 0) continue;
                raster.setSample(i, j, 0, raster.getSample(i, j, 0) / 2);
                raster.setSample(i, j, 1, raster.getSample(i, j, 1) / 2);
                raster.setSample(i, j, 2, raster.getSample(i, j, 2) / 2);
            }
        }
        return image;
    }

    public void func_110551_a(IResourceManager resourceManager) {
        this.func_147631_c();
        if (this.packet != null) {
            int tId = this.func_110552_b();
            if (tId < 0) {
                return;
            }
            TextureUtil.func_110989_a((int)this.func_110552_b(), (BufferedImage)this.getImage(), (boolean)false, (boolean)false);
            this.width = this.packet.getSize();
            this.height = this.packet.getSize();
        }
    }

    public void loadTexture(IResourceManager resourceManager, boolean invert) {
        this.invert = invert;
        this.func_110551_a(resourceManager);
    }

    public void loadTexture(IResourceManager resourceManager, String selected, boolean invert) {
        this.selected = selected;
        this.loadTexture(resourceManager, invert);
    }

    public int glBindTexture() {
        if (this.field_110553_a < 0) {
            return this.field_110553_a;
        }
        GL11.glBindTexture((int)3553, (int)this.func_110552_b());
        return this.field_110553_a;
    }

    public void draw(int x, int y) {
        float f = 1.0f / (float)this.width;
        float f1 = 1.0f / (float)this.height;
        int u = 0;
        int v = 0;
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)x, (double)(y + this.height), 0.0, (double)((float)u * f), (double)((float)(v + this.height) * f1));
        tessellator.func_78374_a((double)(x + this.width), (double)(y + this.height), 0.0, (double)((float)(u + this.width) * f), (double)((float)(v + this.height) * f1));
        tessellator.func_78374_a((double)(x + this.width), (double)y, 0.0, (double)((float)(u + this.width) * f), (double)((float)v * f1));
        tessellator.func_78374_a((double)x, (double)y, 0.0, (double)((float)u * f), (double)((float)v * f1));
        tessellator.func_78381_a();
    }
}

