/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.drawable;

import com.gtnewhorizons.modularui.api.drawable.UITexture;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class FallbackableUITexture {
    private final UITexture candidate;
    private final Object fallback;
    private Boolean useFallback = null;
    private static final List<FallbackableUITexture> ALL_INSTANCES = new ArrayList<FallbackableUITexture>();

    public FallbackableUITexture(UITexture candidate, UITexture fallback) {
        this(candidate, (Object)fallback);
    }

    public FallbackableUITexture(UITexture candidate, FallbackableUITexture fallback) {
        this(candidate, (Object)fallback);
    }

    public FallbackableUITexture(UITexture fallback) {
        this(null, fallback);
    }

    private FallbackableUITexture(UITexture candidate, Object fallback) {
        this.candidate = candidate;
        this.fallback = fallback;
        ALL_INSTANCES.add(this);
    }

    public UITexture get() {
        this.verifyCandidate();
        if (this.useFallback.booleanValue()) {
            return this.castFallback();
        }
        return this.candidate;
    }

    private void verifyCandidate() {
        if (this.useFallback == null) {
            if (NetworkUtils.isDedicatedClient()) {
                if (this.candidate == null) {
                    this.useFallback = true;
                } else {
                    try {
                        Minecraft.func_71410_x().func_110442_L().func_110536_a(this.candidate.location);
                        this.useFallback = false;
                    }
                    catch (IOException e) {
                        this.useFallback = true;
                    }
                }
            } else {
                this.useFallback = true;
            }
        }
    }

    private UITexture castFallback() {
        if (this.fallback instanceof UITexture) {
            return (UITexture)this.fallback;
        }
        if (this.fallback instanceof FallbackableUITexture) {
            return ((FallbackableUITexture)this.fallback).get();
        }
        throw new RuntimeException("Unexpected type found for fallback: " + this.fallback.getClass());
    }

    public static void reload() {
        for (FallbackableUITexture t : ALL_INSTANCES) {
            t.useFallback = null;
        }
    }
}

