/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.neiaddons.network;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.HashMap;
import java.util.Map;
import net.bdew.neiaddons.NEIAddons;
import net.bdew.neiaddons.api.SubPacketHandler;
import net.bdew.neiaddons.network.PacketHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetHandlerPlayServer;
import org.apache.commons.lang3.StringUtils;

public class ServerHandler
extends SimpleChannelInboundHandler<NBTTagCompound> {
    private static Map<String, SubPacketHandler> handlers = new HashMap<String, SubPacketHandler>();

    public ServerHandler() {
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public static void registerHandler(String command, SubPacketHandler handler) {
        if (handlers.containsKey(command)) {
            throw new RuntimeException(String.format("Tried to register handler for command %s that's already registered for %s", command, handler.toString()));
        }
        handlers.put(command, handler);
    }

    protected void channelRead0(ChannelHandlerContext ctx, NBTTagCompound msg) throws Exception {
        String cmd = msg.func_74779_i("cmd");
        NBTTagCompound data = msg.func_74775_l("data");
        NetHandlerPlayServer nh = (NetHandlerPlayServer)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get();
        this.processCommand(cmd, data, nh.field_147369_b);
    }

    public void processCommand(String cmd, NBTTagCompound data, EntityPlayerMP from) {
        if (handlers.containsKey(cmd)) {
            NEIAddons.logInfo("Handling %s from %s -> %s", cmd, from.getDisplayName(), handlers.get(cmd).toString());
            try {
                handlers.get(cmd).handle(data, from);
            }
            catch (Throwable e) {
                NEIAddons.logSevereExc(e, "Error processing command '%s' from '%s'", cmd, from.getDisplayName());
            }
        } else {
            NEIAddons.logWarning("Uknown packet from client '%s': %s", from.getDisplayName(), cmd);
        }
    }

    private void sendPlayerHello(EntityPlayer player) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("commands", StringUtils.join(handlers.keySet(), (char)';'));
        nbt.func_74768_a("version", 1);
        PacketHelper.sendToClient("hello", nbt, (EntityPlayerMP)player);
    }

    @SubscribeEvent
    public void handlePlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent ev) {
        this.sendPlayerHello(ev.player);
    }

    @SubscribeEvent
    public void handlePlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent ev) {
        this.sendPlayerHello(ev.player);
    }
}

