/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.handler;

import com.github.lunatrius.ingameinfo.InGameInfoCore;
import com.github.lunatrius.ingameinfo.handler.ConfigurationHandler;
import com.github.lunatrius.ingameinfo.tag.Tag;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiChat;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class Ticker {
    public static final Ticker INSTANCE = new Ticker();
    private final Minecraft client = Minecraft.func_71410_x();
    private final InGameInfoCore core = InGameInfoCore.INSTANCE;

    private Ticker() {
    }

    @SubscribeEvent
    public void onRenderGameOverlayEventPre(RenderGameOverlayEvent.Pre event) {
        if (ConfigurationHandler.showHUD && ConfigurationHandler.replaceDebug && event.type == RenderGameOverlayEvent.ElementType.DEBUG) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.side == Side.CLIENT && event.phase == TickEvent.Phase.END) {
            this.client.field_71424_I.func_76320_a("ingameinfo");
            if (this.isRunning()) {
                this.core.onTickClient();
            }
            if (!ConfigurationHandler.showHUD || this.client.field_71474_y == null) {
                Tag.setServer(null);
                Tag.releaseResources();
            }
            this.client.field_71424_I.func_76319_b();
        }
    }

    @SubscribeEvent
    public void onRenderGUI(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            this.client.field_71424_I.func_76320_a("ingameinfo");
            if (this.isRunning()) {
                this.core.onTickRender(event.resolution);
            }
            this.client.field_71424_I.func_76319_b();
        }
    }

    private boolean isRunning() {
        if (ConfigurationHandler.showHUD) {
            if (this.client.field_71424_I.field_76327_a) {
                return true;
            }
            if (this.client.field_71474_y != null && ConfigurationHandler.replaceDebug == this.client.field_71474_y.field_74330_P) {
                if (!ConfigurationHandler.showOnPlayerList && this.client.field_71474_y.field_74321_H.func_151470_d()) {
                    return false;
                }
                if (this.client.field_71474_y.field_74319_N) {
                    return false;
                }
                if (this.client.field_71462_r == null) {
                    return true;
                }
                if (ConfigurationHandler.showInChat && this.client.field_71462_r instanceof GuiChat) {
                    return true;
                }
            }
        }
        return false;
    }
}

