/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.network;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.EnumMap;
import mcp.mobius.mobiuscore.profiler.ProfilerSection;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.basetypes.AmountHolder;
import mcp.mobius.opis.data.holders.basetypes.SerialInt;
import mcp.mobius.opis.data.holders.basetypes.SerialLong;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTick;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTileEntity;
import mcp.mobius.opis.data.holders.newtypes.DataBlockTileEntityPerClass;
import mcp.mobius.opis.data.holders.newtypes.DataEntity;
import mcp.mobius.opis.data.holders.newtypes.DataEntityPerClass;
import mcp.mobius.opis.data.holders.newtypes.DataEvent;
import mcp.mobius.opis.data.holders.newtypes.DataNetworkTick;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.data.holders.stats.StatsChunk;
import mcp.mobius.opis.data.managers.ChunkManager;
import mcp.mobius.opis.data.managers.EntityManager;
import mcp.mobius.opis.data.managers.TileEntityManager;
import mcp.mobius.opis.data.profilers.ProfilerEvent;
import mcp.mobius.opis.events.PlayerTracker;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.network.packets.client.PacketReqChunks;
import mcp.mobius.opis.network.packets.client.PacketReqData;
import mcp.mobius.opis.network.packets.server.NetDataCommand;
import mcp.mobius.opis.network.packets.server.NetDataList;
import mcp.mobius.opis.network.packets.server.NetDataValue;
import mcp.mobius.opis.network.rcon.RConHandler;
import mcp.mobius.shadow.org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S02PacketChat;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

@ChannelHandler.Sharable
public class PacketManager {
    private static final EnumMap<Side, FMLEmbeddedChannel> channels = Maps.newEnumMap(Side.class);

    public static void init() {
        String codecName;
        FMLEmbeddedChannel channel;
        if (!channels.isEmpty()) {
            return;
        }
        Codec codec = new Codec();
        codec.addDiscriminator(0, PacketReqChunks.class);
        codec.addDiscriminator(1, PacketReqData.class);
        codec.addDiscriminator(2, NetDataCommand.class);
        codec.addDiscriminator(3, NetDataList.class);
        codec.addDiscriminator(4, NetDataValue.class);
        channels.putAll(NetworkRegistry.INSTANCE.newChannel("Opis", new ChannelHandler[]{codec}));
        if (FMLCommonHandler.instance().getSide().isClient()) {
            channel = channels.get(Side.CLIENT);
            codecName = channel.findChannelHandlerNameForType(Codec.class);
            channel.pipeline().addAfter(codecName, "ClientHandler", (ChannelHandler)new HandlerClient());
        }
        channel = channels.get(Side.SERVER);
        codecName = channel.findChannelHandlerNameForType(Codec.class);
        channel.pipeline().addAfter(codecName, "ServerHandler", (ChannelHandler)new HandlerServer());
    }

    public static void sendToServer(PacketBase packet) {
        channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channels.get(Side.CLIENT).writeAndFlush((Object)packet);
    }

    public static void sendToPlayer(PacketBase packet, EntityPlayer player) {
        if (player instanceof FakePlayer && RConHandler.fakePlayersRcon.containsKey((Object)player)) {
            RConHandler.sendToPlayerRCon(packet, (FakePlayer)player);
        } else if (player instanceof FakePlayer && RConHandler.fakePlayersNexus.containsKey((Object)player)) {
            RConHandler.sendToPlayerNexus(packet, (FakePlayer)player);
        } else {
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
            channels.get(Side.SERVER).writeAndFlush((Object)packet);
        }
    }

    public static void sendToPlayer(Packet packet, EntityPlayerMP player) {
        player.field_71135_a.func_147359_a(packet);
    }

    public static void sendToAllAround(PacketBase packet, NetworkRegistry.TargetPoint point) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public static void sendToDimension(PacketBase packet, int dimension) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        channels.get(Side.SERVER).writeAndFlush((Object)packet);
    }

    public static void sendToAll(PacketBase packet) {
        channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channels.get(Side.SERVER).writeAndFlush((Object)packet);
        for (Object fakePlayer : RConHandler.fakePlayersRcon.keySet().toArray()) {
            RConHandler.sendToPlayerRCon(packet, (FakePlayer)fakePlayer);
        }
        for (Object fakePlayer : RConHandler.fakePlayersNexus.keySet().toArray()) {
            RConHandler.sendToPlayerNexus(packet, (FakePlayer)fakePlayer);
        }
    }

    public static Packet toMcPacket(PacketBase packet) {
        return channels.get(FMLCommonHandler.instance().getEffectiveSide()).generatePacketFrom((Object)packet);
    }

    public static void validateAndSend(PacketBase capsule, EntityPlayerMP player) {
        if (!capsule.msg.isDisplayActive(PlayerTracker.INSTANCE.getPlayerSelectedTab(player))) {
            return;
        }
        if (capsule.msg.canPlayerUseCommand(player)) {
            PacketManager.sendToPlayer(capsule, (EntityPlayer)player);
        }
    }

    public static void sendPacketToAllSwing(PacketBase capsule) {
        for (EntityPlayerMP player : PlayerTracker.INSTANCE.playersSwing) {
            PacketManager.validateAndSend(capsule, player);
        }
    }

    public static void sendChatMsg(String msg, EntityPlayerMP player) {
        PacketManager.sendToPlayer((Packet)new S02PacketChat((IChatComponent)new ChatComponentText(msg)), player);
    }

    public static void splitAndSend(Message msg, ArrayList<? extends ISerializable> data, EntityPlayerMP player) {
        for (int i = 0; i < data.size(); i += 500) {
            PacketManager.validateAndSend(new NetDataList(msg, data.subList(i, Math.min(i + 500, data.size()))), player);
        }
    }

    public static void sendFullUpdate(EntityPlayerMP player) {
        ArrayList<DataEntity> timingEntities = EntityManager.INSTANCE.getWorses(100);
        ArrayList<DataBlockTileEntity> timingTileEnts = TileEntityManager.INSTANCE.getWorses(100);
        ArrayList<StatsChunk> timingChunks = ChunkManager.INSTANCE.getTopChunks(100);
        ArrayList<DataEntityPerClass> timingEntsClass = EntityManager.INSTANCE.getTotalPerClass();
        ArrayList<DataBlockTileEntityPerClass> timingTEsClass = TileEntityManager.INSTANCE.getCumulativeTimingTileEntities();
        DataTiming totalTimeTE = TileEntityManager.INSTANCE.getTotalUpdateTime();
        DataTiming totalTimeEnt = EntityManager.INSTANCE.getTotalUpdateTime();
        DataNetworkTick totalNetwork = new DataNetworkTick().fill();
        DataBlockTick totalWorldTick = new DataBlockTick().fill();
        ArrayList<DataEvent> timingEvents = new ArrayList<DataEvent>();
        HashBasedTable<Class, String, DescriptiveStatistics> eventData = ((ProfilerEvent)ProfilerSection.EVENT_INVOKE.getProfiler()).data;
        HashBasedTable<Class, String, String> eventMod = ((ProfilerEvent)ProfilerSection.EVENT_INVOKE.getProfiler()).dataMod;
        for (Table.Cell cell : eventData.cellSet()) {
            timingEvents.add(new DataEvent().fill((Table.Cell<Class, String, DescriptiveStatistics>)cell, (String)eventMod.get(cell.getRowKey(), cell.getColumnKey())));
        }
        ArrayList<DataEvent> timingTicks = new ArrayList<DataEvent>();
        HashBasedTable<Class, String, DescriptiveStatistics> eventTickData = ((ProfilerEvent)ProfilerSection.EVENT_INVOKE.getProfiler()).dataTick;
        HashBasedTable<Class, String, String> eventTickMod = ((ProfilerEvent)ProfilerSection.EVENT_INVOKE.getProfiler()).dataModTick;
        for (Table.Cell cell : eventTickData.cellSet()) {
            timingTicks.add(new DataEvent().fill((Table.Cell<Class, String, DescriptiveStatistics>)cell, (String)eventTickMod.get(cell.getRowKey(), cell.getColumnKey())));
        }
        PacketManager.validateAndSend(new NetDataList(Message.LIST_TIMING_HANDLERS, timingTicks), player);
        PacketManager.validateAndSend(new NetDataList(Message.LIST_TIMING_ENTITIES, timingEntities), player);
        PacketManager.validateAndSend(new NetDataList(Message.LIST_TIMING_TILEENTS, timingTileEnts), player);
        PacketManager.validateAndSend(new NetDataList(Message.LIST_TIMING_TILEENTS_PER_CLASS, timingTEsClass), player);
        PacketManager.validateAndSend(new NetDataList(Message.LIST_TIMING_CHUNK, timingChunks), player);
        PacketManager.validateAndSend(new NetDataList(Message.LIST_TIMING_EVENTS, timingEvents), player);
        PacketManager.validateAndSend(new NetDataList(Message.LIST_TIMING_ENTITIES_PER_CLASS, timingEntsClass), player);
        PacketManager.validateAndSend(new NetDataValue(Message.VALUE_TIMING_TILEENTS, totalTimeTE), player);
        PacketManager.validateAndSend(new NetDataValue(Message.VALUE_TIMING_ENTITIES, totalTimeEnt), player);
        PacketManager.validateAndSend(new NetDataValue(Message.VALUE_TIMING_WORLDTICK, totalWorldTick), player);
        PacketManager.validateAndSend(new NetDataValue(Message.VALUE_TIMING_NETWORK, totalNetwork), player);
        PacketManager.validateAndSend(new NetDataValue(Message.STATUS_TIME_LAST_RUN, new SerialLong(ProfilerSection.timeStampLastRun)), player);
        PacketManager.validateAndSend(new NetDataValue(Message.STATUS_ACCESS_LEVEL, new SerialInt(PlayerTracker.INSTANCE.getPlayerAccessLevel(player).ordinal())), player);
        String name = player.func_146103_bH().getName();
        boolean filtered = false;
        if (PlayerTracker.INSTANCE.filteredAmount.containsKey(name)) {
            filtered = PlayerTracker.INSTANCE.filteredAmount.get(name);
        }
        ArrayList<AmountHolder> amountEntities = EntityManager.INSTANCE.getCumulativeEntities(filtered);
        PacketManager.validateAndSend(new NetDataList(Message.LIST_AMOUNT_ENTITIES, amountEntities), player);
    }

    @ChannelHandler.Sharable
    private static final class HandlerServer
    extends SimpleChannelInboundHandler<PacketBase> {
        private HandlerServer() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, PacketBase packet) throws Exception {
            EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
            packet.actionServer(player.field_70170_p, player);
        }
    }

    @ChannelHandler.Sharable
    @SideOnly(value=Side.CLIENT)
    private static final class HandlerClient
    extends SimpleChannelInboundHandler<PacketBase> {
        private HandlerClient() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, PacketBase packet) throws Exception {
            Minecraft mc = Minecraft.func_71410_x();
            packet.actionClient((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
        }
    }

    private static final class Codec
    extends FMLIndexedMessageToMessageCodec<PacketBase> {
        private Codec() {
        }

        public void encodeInto(ChannelHandlerContext ctx, PacketBase packet, ByteBuf target) throws Exception {
            ByteArrayDataOutput output = ByteStreams.newDataOutput();
            packet.encode(output);
            target.writeBytes(output.toByteArray());
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, PacketBase packet) {
            ByteArrayDataInput input = ByteStreams.newDataInput((byte[])source.array());
            input.skipBytes(1);
            packet.decode(input);
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                this.actionClient(packet);
            } else {
                this.actionServer(ctx, packet);
            }
        }

        @SideOnly(value=Side.CLIENT)
        private void actionClient(PacketBase packet) {
            Minecraft mc = Minecraft.func_71410_x();
            packet.actionClient((World)mc.field_71441_e, (EntityPlayer)mc.field_71439_g);
        }

        private void actionServer(ChannelHandlerContext ctx, PacketBase packet) {
            EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
            packet.actionServer(player.field_70170_p, player);
        }

        public FMLIndexedMessageToMessageCodec<PacketBase> addDiscriminator(int discriminator, Class<? extends PacketBase> type) {
            if (!Codec.hasEmptyContructor(type)) {
                LogManager.getLogger().log(Level.FATAL, type.getName() + "does not have an empty constructor!");
            }
            return super.addDiscriminator(discriminator, type);
        }

        private static boolean hasEmptyContructor(Class type) {
            try {
                for (Constructor<?> c : type.getConstructors()) {
                    if (c.getParameterTypes().length != 0) continue;
                    return true;
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            return false;
        }
    }
}

