/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs;

import chylex.hee.system.collections.WeightedList;
import chylex.hee.system.collections.weight.IWeightProvider;
import chylex.hee.world.feature.blobs.BlobGenerator;
import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.util.IRandomAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.commons.lang3.tuple.Pair;

public final class BlobPattern
implements IWeightProvider {
    private final int weight;
    private final WeightedList<BlobGenerator> generators = new WeightedList((IWeightProvider[])new BlobGenerator[0]);
    private final WeightedList<BlobPopulator> populators = new WeightedList((IWeightProvider[])new BlobPopulator[0]);
    private IRandomAmount populatorAmountGen;
    private int minPopulatorAmount;
    private int maxPopulatorAmount;
    private final Comparator<BlobPopulator> populatorSorter = new Comparator<BlobPopulator>(){

        @Override
        public int compare(BlobPopulator pop1, BlobPopulator pop2) {
            return BlobPattern.this.populators.indexOf(pop1) < BlobPattern.this.populators.indexOf(pop2) ? -1 : 1;
        }
    };

    public BlobPattern(int weight) {
        this.weight = weight;
    }

    public BlobPattern addGenerators(BlobGenerator[] generator) {
        this.generators.addAll(generator);
        return this;
    }

    public BlobPattern addPopulators(BlobPopulator[] populator) {
        this.populators.addAll(populator);
        return this;
    }

    public BlobPattern setPopulatorAmountProvider(IRandomAmount populatorAmountGen, int minPopulatorAmount, int maxPopulatorAmount) {
        this.populatorAmountGen = populatorAmountGen;
        this.minPopulatorAmount = minPopulatorAmount;
        this.maxPopulatorAmount = maxPopulatorAmount;
        return this;
    }

    public Pair<BlobGenerator, List<BlobPopulator>> generatePattern(Random rand) {
        ArrayList<BlobPopulator> chosenPopulators = new ArrayList<BlobPopulator>();
        if (this.populatorAmountGen != null && !this.populators.isEmpty()) {
            WeightedList blobPopulators = new WeightedList((IWeightProvider[])new BlobPopulator[0]);
            blobPopulators.addAll(this.populators);
            int amount = this.populatorAmountGen.generate(rand, this.minPopulatorAmount, this.maxPopulatorAmount);
            for (int a = 0; a < amount && !blobPopulators.isEmpty(); ++a) {
                BlobPopulator populator = (BlobPopulator)blobPopulators.getRandomItem(rand);
                chosenPopulators.add(populator);
                blobPopulators.remove(populator);
            }
            Collections.sort(chosenPopulators, this.populatorSorter);
        }
        return Pair.of((Object)this.generators.getRandomItem(rand), chosenPopulators);
    }

    @Override
    public int getWeight() {
        return this.weight;
    }
}

