/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main.utils.net;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLEventChannel;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.internal.FMLProxyPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import magicbees.main.MagicBees;
import magicbees.main.utils.ChunkCoords;
import magicbees.main.utils.LogHelper;
import magicbees.main.utils.error.InvalidEventTypeIndexException;
import magicbees.main.utils.net.EventAuraChargeUpdate;
import magicbees.main.utils.net.EventFlagsUpdate;
import magicbees.main.utils.net.EventInventoryUpdate;
import magicbees.tileentity.AuraCharges;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.tileentity.TileEntity;

public class NetworkEventHandler {
    public static final String CHANNEL_NAME = "MagicBees";
    private FMLEventChannel channel = NetworkRegistry.INSTANCE.newEventDrivenChannel("MagicBees");

    public static NetworkEventHandler getInstance() {
        return MagicBees.object.netHandler;
    }

    public NetworkEventHandler() {
        this.channel.register((Object)this);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ServerCustomPacketEvent event) {
        this.parseAndDispatchPacket(event.packet.payload(), ((NetHandlerPlayServer)event.handler).field_147369_b);
    }

    @SubscribeEvent
    public void onPacket(FMLNetworkEvent.ClientCustomPacketEvent event) {
        this.parseAndDispatchPacket(event.packet.payload(), null);
    }

    public void sendInventoryUpdate(TileEntity entity, int slotIndex, ItemStack itemStack) {
        EventInventoryUpdate event = new EventInventoryUpdate(new ChunkCoords(entity), slotIndex, itemStack);
        FMLProxyPacket packet = event.getPacket();
        this.sendPacket(packet);
    }

    public void sendFlagsUpdate(TileEntity entity, int[] flags) {
        EventFlagsUpdate event = new EventFlagsUpdate(new ChunkCoords(entity), flags);
        FMLProxyPacket packet = event.getPacket();
        this.sendPacket(packet);
    }

    public <T extends TileEntity> void sendAuraChargeUpdate(T entity, AuraCharges auraCharges) {
        EventAuraChargeUpdate event = new EventAuraChargeUpdate(new ChunkCoords(entity), auraCharges);
        FMLProxyPacket packet = event.getPacket();
        this.sendPacket(packet);
    }

    private void sendPacket(FMLProxyPacket packet) {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.channel.sendToAll(packet);
        } else {
            this.channel.sendToServer(packet);
        }
    }

    private void parseAndDispatchPacket(ByteBuf packetPayload, EntityPlayerMP player) {
        try {
            DataInputStream data = new DataInputStream((InputStream)new ByteBufInputStream(packetPayload));
            this.processEventData(data, player);
            data.close();
        }
        catch (IOException e) {
            LogHelper.info("DataInputStream had a problem closing. Good for it.");
        }
    }

    private void processEventData(DataInputStream data, EntityPlayerMP player) throws IOException {
        int eventId = data.readInt();
        if (eventId == EventType.INVENTORY_UPDATE.ordinal()) {
            EventInventoryUpdate eventData = new EventInventoryUpdate(data);
            eventData.process(player);
        } else if (eventId == EventType.FLAGS_UPDATE.ordinal()) {
            EventFlagsUpdate eventData = new EventFlagsUpdate(data);
            eventData.process(player);
        } else if (eventId == EventType.AURA_CHARGE_UPDATE.ordinal()) {
            EventAuraChargeUpdate evenData = new EventAuraChargeUpdate(data);
            evenData.process(player);
        } else {
            throw new InvalidEventTypeIndexException("");
        }
    }

    public static enum EventType {
        UNKNOWN,
        INVENTORY_UPDATE,
        FLAGS_UPDATE,
        AURA_CHARGE_UPDATE;

    }
}

