/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.layout.Layout;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import java.util.ArrayList;
import java.util.Collection;

public abstract class CompositeDiagram
extends Diagram {
    public CompositeDiagram(Layout layout, ImmutableList<? extends Interactable> interactables) {
        super(layout, interactables);
    }

    public CompositeDiagram(Diagram diagram) {
        super(diagram.layout, (Multiset<Layout.Key>)diagram.slotInsertions, diagram.interactables);
    }

    @Override
    public Iterable<Interactable> interactables(DiagramState diagramState) {
        ArrayList<Iterable<Interactable>> iterables = new ArrayList<Iterable<Interactable>>();
        iterables.add(super.interactables(diagramState));
        this.activeDiagrams(diagramState).forEach(diagram -> iterables.add(diagram.interactables(diagramState)));
        return Iterables.concat(iterables);
    }

    @Override
    public Dimension dimension(DiagramState diagramState) {
        return this.activeDiagrams(diagramState).stream().map(diagram -> diagram.dimension(diagramState)).reduce(super.dimension(diagramState), Dimension::max);
    }

    @Override
    public void drawBackground(DiagramState diagramState) {
        super.drawBackground(diagramState);
        this.activeDiagrams(diagramState).forEach(diagram -> diagram.drawBackground(diagramState));
    }

    @Override
    public void drawForeground(DiagramState diagramState) {
        super.drawForeground(diagramState);
        this.activeDiagrams(diagramState).forEach(diagram -> diagram.drawForeground(diagramState));
    }

    protected abstract Collection<Diagram> activeDiagrams(DiagramState var1);
}

