/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.gitlab.cdagaming.craftpresence.core.Constants;
import com.gitlab.cdagaming.craftpresence.core.impl.Pair;
import com.gitlab.cdagaming.craftpresence.core.utils.MappingUtils;
import com.gitlab.cdagaming.craftpresence.core.utils.StringUtils;
import external.io.github.classgraph.ClassInfo;
import external.org.meteordev.starscript.value.Value;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.entity.TileEntityUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.RenderUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.awt.Color;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class ScrollableListControl
extends GuiSlot {
    public final Map<String, String> entryAliases = StringUtils.newHashMap();
    public final RenderType renderType;
    public String currentValue;
    public List<String> currentHoverText = StringUtils.newArrayList();
    public List<String> itemList;
    public IdentifierType identifierType = IdentifierType.None;
    public ExtendedScreen currentScreen;

    public ScrollableListControl(@Nonnull Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, currentScreen, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(@Nonnull Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.setList(itemList);
        this.currentScreen = currentScreen;
        this.currentValue = currentValue;
        this.renderType = renderType;
    }

    public ScrollableListControl(@Nonnull Minecraft mc, ExtendedScreen currentScreen, int width, int height, int topIn, int bottomIn, List<String> itemList, String currentValue, RenderType renderType) {
        this(mc, currentScreen, width, height, topIn, bottomIn, renderType.canRenderImage() ? 45 : 18, itemList, currentValue, renderType);
    }

    public ScrollableListControl setIdentifierType(IdentifierType type) {
        this.identifierType = type;
        return this;
    }

    public boolean isWithinBounds(int mouseX, int mouseY) {
        return RenderUtils.isMouseWithin(mouseX, mouseY, this.field_148153_b, this.field_148154_c, this.field_148152_e, this.field_148151_d);
    }

    protected int func_148127_b() {
        return this.itemList.size();
    }

    public void func_148144_a(int slotIndex, boolean isDoubleClick, int mouseX, int mouseY) {
        this.currentValue = this.getSelectedItem(slotIndex);
    }

    public boolean func_148131_a(int slotIndex) {
        return this.getSelectedItem(slotIndex).equals(this.currentValue);
    }

    protected void func_148123_a() {
        this.currentScreen.func_146276_q_();
    }

    protected void func_148126_a(int slotIndex, int xPos, int yPos, int heightIn, Tessellator tessellatorIn, int mouseXIn, int mouseYIn) {
        this.renderSlotItem(this.getSelectedItem(slotIndex), xPos, yPos, this.func_148139_c(), heightIn, mouseXIn, mouseYIn);
    }

    public String getSelectedItem(int slotIndex) {
        try {
            return this.itemList.get(slotIndex);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public FontRenderer getFontRenderer() {
        return GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        return this.getFontRenderer().field_78288_b;
    }

    public void setList(List<String> itemList) {
        if (itemList == null) {
            itemList = StringUtils.newArrayList();
        }
        if (!itemList.equals(this.itemList)) {
            this.itemList = itemList;
            this.func_148145_f(Integer.MIN_VALUE);
        }
        this.setupAliasData();
    }

    public void setupAliasData() {
        this.entryAliases.clear();
        Iterator<String> iterator = StringUtils.newArrayList(this.itemList).iterator();
        while (iterator.hasNext()) {
            String originalName;
            String displayName = originalName = iterator.next();
            if (this.renderType == RenderType.EntityData && StringUtils.isValidUuid(originalName)) {
                String fullUuid = StringUtils.getFromUuid(originalName, false);
                String trimmedUuid = StringUtils.getFromUuid(originalName, true);
                displayName = CraftPresence.ENTITIES.PLAYER_BINDINGS.getOrDefault(fullUuid, trimmedUuid);
            }
            if (originalName.equals(displayName)) continue;
            this.entryAliases.put(originalName, displayName);
        }
    }

    public void renderSlotItem(String originalName, int xPos, int yPos, int widthIn, int heightIn, int mouseXIn, int mouseYIn) {
        String identifierName;
        Object data;
        List hoverText = StringUtils.newArrayList();
        String displayName = this.entryAliases.getOrDefault(originalName, originalName);
        int xOffset = xPos;
        boolean isOverEntry = RenderUtils.isMouseOver(mouseXIn, mouseYIn, xPos, yPos, widthIn, heightIn);
        boolean isInBounds = this.isWithinBounds(mouseXIn, mouseYIn);
        boolean isHovering = isInBounds && isOverEntry;
        ResourceLocation texture = new ResourceLocation("");
        if (this.renderType == RenderType.ServerData) {
            data = CraftPresence.SERVER.getDataFromName(originalName);
            if (data != null && !StringUtils.isNullOrEmpty(data.func_147409_e())) {
                String assetUrl = "data:image/unknown;base64," + data.func_147409_e();
                texture = ImageUtils.getTextureFromUrl(originalName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
            } else if (CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint)) {
                String formattedIP = originalName.contains(":") ? StringUtils.formatAddress(originalName, false) : originalName;
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.serverIconEndpoint, originalName), new Pair<String, Supplier<String>>("server.address.short", () -> formattedIP), new Pair<String, Supplier<String>>("server.address.full", () -> originalName)).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode() && isHovering) {
                    hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset) {
            String assetUrl = DiscordAssetUtils.getUrl(this.renderType == RenderType.CustomDiscordAsset ? DiscordAssetUtils.CUSTOM_ASSET_LIST : DiscordAssetUtils.ASSET_LIST, originalName);
            if (this.currentScreen.isDebugMode() && isHovering) {
                hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + assetUrl);
            }
            texture = ImageUtils.getTextureFromUrl(originalName, assetUrl);
        } else if (this.renderType == RenderType.EntityData) {
            boolean isPlayer = CraftPresence.ENTITIES.PLAYER_BINDINGS.containsKey(originalName);
            boolean isValidUuid = StringUtils.isValidUuid(originalName);
            if (isPlayer && CraftPresence.CONFIG.advancedSettings.allowEndpointIcons && !StringUtils.isNullOrEmpty(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint)) {
                String endpointUrl = CraftPresence.CLIENT.compileData(String.format(CraftPresence.CONFIG.advancedSettings.playerSkinEndpoint, originalName), new Pair<String, Supplier<String>>("player.name", () -> originalName), new Pair<String, Supplier<String>>("player.uuid.full", () -> isValidUuid ? StringUtils.getFromUuid(originalName, false) : ""), new Pair<String, Supplier<String>>("player.uuid.short", () -> isValidUuid ? StringUtils.getFromUuid(originalName, true) : "")).get().toString();
                texture = ImageUtils.getTextureFromUrl(originalName, endpointUrl);
                if (this.currentScreen.isDebugMode() && isHovering) {
                    hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.url", new Object[0]) + " " + endpointUrl);
                }
            }
        } else if (this.renderType == RenderType.ItemData && this.renderType.canRenderImage()) {
            ItemStack stack;
            data = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES;
            if (data.containsKey(originalName) && !TileEntityUtils.isEmpty(stack = (ItemStack)data.get(originalName))) {
                RenderUtils.drawItemStack(CraftPresence.instance, this.getFontRenderer(), xOffset, yPos + 4, stack, 2.0f);
                xOffset += 35;
            }
        } else if (this.renderType == RenderType.Placeholder && isHovering) {
            Supplier<Value> suppliedInfo;
            boolean addExtraData;
            String placeholderTranslation = String.format("%s.placeholders.%s.description", "craftpresence", originalName);
            String placeholderUsage = String.format("%s.placeholders.%s.usage", "craftpresence", originalName);
            if (Constants.TRANSLATOR.hasTranslation(placeholderTranslation)) {
                hoverText.add(String.format("%s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.description", new Object[0]), Constants.TRANSLATOR.translate(placeholderTranslation, new Object[0])));
            }
            if (Constants.TRANSLATOR.hasTranslation(placeholderUsage)) {
                hoverText.add(String.format("%s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.usage", new Object[0]), Constants.TRANSLATOR.translate(placeholderUsage, new Object[0])));
            }
            if ((addExtraData = CraftPresence.CONFIG.advancedSettings.allowPlaceholderPreviews) && CraftPresence.CLIENT.isDefaultPlaceholder(originalName.toLowerCase()) && (suppliedInfo = CraftPresence.CLIENT.getArgument(originalName)) != null) {
                Value rawValue = suppliedInfo.get();
                String tagValue = rawValue.toString();
                if (!(rawValue.isNull() || rawValue.isFunction() || StringUtils.isNullOrEmpty(tagValue))) {
                    hoverText.add(String.format("%s \"%s\"", Constants.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
                }
            }
        }
        if (this.renderType.canRenderImage() && !ImageUtils.isTextureNull(texture)) {
            double yOffset = (double)yPos + 4.5;
            double size = 32.0;
            RenderUtils.drawTexture(CraftPresence.instance, xOffset, (double)xOffset + 32.0, yOffset, yOffset + 32.0, 0.0, 0.0, 1.0, 0.0, 1.0, Color.white, Color.white, texture);
            if (this.currentScreen.isDebugMode() && isHovering) {
                hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.texture_path", new Object[0]) + " " + texture);
            }
            xOffset += 35;
        }
        if (!(identifierName = this.identifierType.getIdentifier(originalName)).equals(displayName) && isHovering) {
            hoverText.add(Constants.TRANSLATOR.translate("gui.config.message.editor.original", new Object[0]) + " " + identifierName);
        }
        this.getFontRenderer().func_78261_a(displayName, xOffset, yPos + (heightIn / 2 - this.getFontHeight() / 2), 0xFFFFFF);
        if (isHovering) {
            this.currentHoverText = hoverText;
        }
    }

    public static enum RenderType {
        DiscordAsset,
        CustomDiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        Placeholder(false),
        None(false);

        private final boolean canRenderImage;

        private RenderType() {
            this.canRenderImage = true;
        }

        private RenderType(boolean canRenderImage) {
            this.canRenderImage = canRenderImage;
        }

        public boolean canRenderImage() {
            return this.canRenderImage && !CraftPresence.CONFIG.accessibilitySettings.stripExtraGuiElements;
        }
    }

    public static enum IdentifierType {
        Gui,
        None;


        public String getIdentifier(String originalName) {
            String identifierName;
            switch (this) {
                case Gui: {
                    ClassInfo target = CraftPresence.GUIS.GUI_CLASSES.get(originalName);
                    identifierName = target != null ? MappingUtils.getCanonicalName(target) : originalName;
                    break;
                }
                default: {
                    identifierName = originalName;
                }
            }
            return identifierName;
        }
    }
}

