/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.crossmod.ic2;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import goodgenerator.util.ItemRefer;
import ic2.api.crops.CropCard;
import ic2.api.crops.ICropTile;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import speiger.src.crops.api.ICropCardInfo;

public class GGCropsSaltyRoot
extends CropCard
implements ICropCardInfo {
    private final String cropName;

    public GGCropsSaltyRoot(String name) {
        this.cropName = name;
    }

    public String name() {
        return this.cropName;
    }

    public int tier() {
        return 4;
    }

    public int stat(int n) {
        return 0;
    }

    public String[] attributes() {
        return new String[]{"Salt", "Gray", "Root", "Hydrophobic"};
    }

    public int maxSize() {
        return 3;
    }

    public boolean canGrow(ICropTile crop) {
        return crop.getSize() < this.maxSize();
    }

    public int getOptimalHavestSize(ICropTile crop) {
        return 3;
    }

    public boolean canBeHarvested(ICropTile crop) {
        return crop.getSize() == 3;
    }

    public ItemStack getGain(ICropTile crop) {
        return ItemRefer.Salty_Root.get(1);
    }

    public String discoveredBy() {
        return "GlodBlock";
    }

    public String owner() {
        return "GoodGenerator";
    }

    public String displayName() {
        return StatCollector.func_74838_a((String)("crops." + this.cropName.toLowerCase().replace(" ", "")));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(IIconRegister iconRegister) {
        this.textures = new IIcon[this.maxSize()];
        for (int i = 1; i <= this.textures.length; ++i) {
            this.textures[i - 1] = iconRegister.func_94245_a("GoodGenerator:crops/" + this.name() + "." + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getSprite(ICropTile crop) {
        if (crop.getSize() <= 0 || crop.getSize() > this.textures.length) {
            return null;
        }
        return this.textures[crop.getSize() - 1];
    }

    public boolean canCross(ICropTile crop) {
        return crop.getSize() > 1;
    }

    public float dropGainChance() {
        return 4.0f;
    }

    public int weightInfluences(ICropTile crop, float humidity, float nutrients, float air) {
        return (int)(-humidity + nutrients * 2.0f + air);
    }

    public List<String> getCropInformation() {
        return Arrays.asList("It prefers dry environment.", "Inedible.");
    }

    public ItemStack getDisplayItem() {
        return ItemRefer.Salty_Root.get(1);
    }
}

