/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.loaders.recipe;

import advsolar.utils.MTRecipeManager;
import advsolar.utils.MTRecipeRecord;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GT_ModHandler;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.MaterialUtils;

public class RecipeLoader_MolecularTransformer {
    public static void run() {
        for (MTRecipeRecord aRecipe : MTRecipeManager.transformerRecipes) {
            int aEU = MaterialUtils.getVoltageForTier(5);
            Logger.INFO("=======================");
            Logger.INFO("Generating GT recipe for Molecular Transformer.");
            Logger.INFO("Input: " + aRecipe.inputStack.func_82833_r() + ", Output: " + aRecipe.outputStack.func_82833_r() + ", EU/t: " + aEU);
            float aTicks = (float)aRecipe.energyPerOperation / (float)aEU;
            Logger.INFO("Ticks: " + aTicks);
            int aTicksRoundedUp = MathUtils.roundToClosestInt(Math.ceil(aTicks));
            Logger.INFO("Ticks: " + aTicksRoundedUp);
            Logger.INFO("Total EU equal or greater? " + (aTicksRoundedUp * aEU >= aRecipe.energyPerOperation));
            CORE.RA.addMolecularTransformerRecipe(aRecipe.inputStack, aRecipe.outputStack, aTicksRoundedUp, aEU, 2);
            Logger.INFO("=======================");
        }
        MTRecipeManager.transformerRecipes.clear();
        if (Mods.AdvancedSolarPanel.isModLoaded() && Mods.GalaxySpace.isModLoaded()) {
            CORE.RA.addMolecularTransformerRecipe(GT_OreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Glowstone, (long)1L), GT_ModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)9), 600, 1920, 2);
            CORE.RA.addMolecularTransformerRecipe(GT_ModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"item.GlowstoneDusts", (long)1L, (int)0), GT_ModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)9), 150, 7680, 2);
            CORE.RA.addMolecularTransformerRecipe(GT_ModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"item.GlowstoneDusts", (long)1L, (int)1), GT_ModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)9), 38, 30720, 2);
            CORE.RA.addMolecularTransformerRecipe(GT_ModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"item.GlowstoneDusts", (long)1L, (int)2), GT_ModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)9), 10, 122880, 2);
            CORE.RA.addMolecularTransformerRecipe(GT_ModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"item.GlowstoneDusts", (long)1L, (int)3), GT_ModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)9), 3, 491520, 2);
            CORE.RA.addMolecularTransformerRecipe(GT_ModHandler.getModItem((String)Mods.GalaxySpace.ID, (String)"item.GlowstoneDusts", (long)1L, (int)4), GT_ModHandler.getModItem((String)Mods.AdvancedSolarPanel.ID, (String)"asp_crafting_items", (long)1L, (int)9), 1, 1996080, 2);
        }
    }
}

