/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.util.minecraft.gregtech;

import gregtech.GT_Mod;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasWorldObjectAndCoords;
import gregtech.common.GT_Pollution;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.AutoMap;
import gtPlusPlus.core.item.base.cell.BaseItemCell;
import gtPlusPlus.core.material.MISC_MATERIALS;
import gtPlusPlus.core.material.MaterialGenerator;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ArrayUtils;

public class PollutionUtils {
    public static AutoMap<FluidStack> mPollutionFluidStacks = new AutoMap();

    public static boolean isPollutionEnabled() {
        return GT_Mod.gregtechproxy.mPollution;
    }

    public static boolean addPollution(IGregTechTileEntity te, int pollutionValue) {
        if (GT_Mod.gregtechproxy.mPollution) {
            GT_Pollution.addPollution((IGregTechTileEntity)te, (int)pollutionValue);
            return true;
        }
        return false;
    }

    public static void addPollution(IHasWorldObjectAndCoords aTileOfSomeSort, int pollutionValue) {
        if (GT_Mod.gregtechproxy.mPollution) {
            Chunk c = aTileOfSomeSort.getWorld().func_72938_d(aTileOfSomeSort.getXCoord(), aTileOfSomeSort.getZCoord());
            PollutionUtils.addPollution(c, pollutionValue);
        }
    }

    public static void addPollution(Chunk aChunk, int pollutionValue) {
        if (GT_Mod.gregtechproxy.mPollution) {
            GT_Pollution.addPollution((Chunk)aChunk, (int)pollutionValue);
        }
    }

    public static void removePollution(IGregTechTileEntity te, int pollutionValue) {
        PollutionUtils.addPollution(te, -pollutionValue);
    }

    public static void removePollution(Chunk aChunk, int pollutionValue) {
        PollutionUtils.addPollution(aChunk, -pollutionValue);
    }

    public static void nullifyPollution(IGregTechTileEntity te) {
        if (te == null) {
            return;
        }
        PollutionUtils.nullifyPollution((IHasWorldObjectAndCoords)te);
    }

    public static void nullifyPollution(IHasWorldObjectAndCoords aTileOfSomeSort) {
        if (aTileOfSomeSort == null) {
            return;
        }
        Chunk c = aTileOfSomeSort.getWorld().func_72938_d(aTileOfSomeSort.getXCoord(), aTileOfSomeSort.getZCoord());
        PollutionUtils.nullifyPollution(c);
    }

    public static void nullifyPollution(Chunk aChunk) {
        if (GT_Mod.gregtechproxy.mPollution) {
            if (aChunk == null) {
                return;
            }
            int getCurrentPollution = PollutionUtils.getPollution(aChunk);
            if (getCurrentPollution > 0) {
                PollutionUtils.removePollution(aChunk, getCurrentPollution);
            }
        }
    }

    public static int getPollution(IGregTechTileEntity te) {
        return GT_Pollution.getPollution((IGregTechTileEntity)te);
    }

    public static int getPollution(Chunk te) {
        return GT_Pollution.getPollution((Chunk)te);
    }

    public static void setPollutionFluids() {
        if (mPollutionFluidStacks.isEmpty()) {
            FluidStack CD = FluidUtils.getFluidStack("carbondioxide", 1000);
            FluidStack CM = FluidUtils.getFluidStack("carbonmonoxide", 1000);
            FluidStack SD = FluidUtils.getFluidStack("sulfurdioxide", 1000);
            if (mPollutionFluidStacks.size() == 0) {
                ItemStack cellCD;
                if (CD != null) {
                    Logger.INFO("[PollutionCompat] Found carbon dioxide fluid, registering it.");
                    mPollutionFluidStacks.put(CD);
                    MISC_MATERIALS.CARBON_DIOXIDE.registerComponentForMaterial(CD);
                    cellCD = ItemUtils.getItemStackOfAmountFromOreDict("cellCarbonDioxide", 1);
                    if (ItemUtils.checkForInvalidItems(cellCD)) {
                        Logger.INFO("[PollutionCompat] Found carbon dioxide cell, registering component.");
                        MISC_MATERIALS.CARBON_DIOXIDE.registerComponentForMaterial(OrePrefixes.cell, cellCD);
                    } else {
                        Logger.INFO("[PollutionCompat] Did not find carbon dioxide cell, registering new component.");
                        new BaseItemCell(MISC_MATERIALS.CARBON_DIOXIDE);
                    }
                } else {
                    MaterialGenerator.generate(MISC_MATERIALS.CARBON_DIOXIDE, false, false);
                }
                if (CM != null) {
                    Logger.INFO("[PollutionCompat] Found carbon monoxide fluid, registering it.");
                    mPollutionFluidStacks.put(CM);
                    MISC_MATERIALS.CARBON_MONOXIDE.registerComponentForMaterial(CM);
                    cellCD = ItemUtils.getItemStackOfAmountFromOreDict("cellCarbonMonoxide", 1);
                    if (ItemUtils.checkForInvalidItems(cellCD)) {
                        Logger.INFO("[PollutionCompat] Found carbon monoxide cell, registering component.");
                        MISC_MATERIALS.CARBON_MONOXIDE.registerComponentForMaterial(OrePrefixes.cell, cellCD);
                    } else {
                        Logger.INFO("[PollutionCompat] Did not find carbon monoxide cell, registering new component.");
                        new BaseItemCell(MISC_MATERIALS.CARBON_MONOXIDE);
                    }
                } else {
                    MaterialGenerator.generate(MISC_MATERIALS.CARBON_MONOXIDE, false, false);
                }
                if (SD != null) {
                    Logger.INFO("[PollutionCompat] Found sulfur dioxide fluid, registering it.");
                    mPollutionFluidStacks.put(SD);
                }
            }
        } else if (mPollutionFluidStacks.size() != 3) {
            Logger.INFO("Unable to detect all 3 pollution fluids. Found: ");
            Logger.INFO(ArrayUtils.toString(mPollutionFluidStacks));
        }
    }
}

