/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.proxy;

import codechicken.nei.api.API;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.data.Pair;
import gtPlusPlus.core.client.renderer.CustomItemBlockRenderer;
import gtPlusPlus.core.client.renderer.CustomOreBlockRenderer;
import gtPlusPlus.core.client.renderer.RenderDecayChest;
import gtPlusPlus.core.client.renderer.RenderMiningExplosivesPrimed;
import gtPlusPlus.core.client.renderer.RenderSickBlaze;
import gtPlusPlus.core.client.renderer.RenderStaballoyConstruct;
import gtPlusPlus.core.client.renderer.RenderToxinball;
import gtPlusPlus.core.common.CommonProxy;
import gtPlusPlus.core.entity.EntityPrimedMiningExplosive;
import gtPlusPlus.core.entity.monster.EntitySickBlaze;
import gtPlusPlus.core.entity.monster.EntityStaballoyConstruct;
import gtPlusPlus.core.entity.projectile.EntityLightningAttack;
import gtPlusPlus.core.entity.projectile.EntityToxinballSmall;
import gtPlusPlus.core.lib.CORE;
import gtPlusPlus.core.tileentities.general.TileEntityDecayablesChest;
import gtPlusPlus.nei.NEI_GTPP_Config;
import gtPlusPlus.xmod.gregtech.common.render.GTPP_CapeRenderer;
import gtPlusPlus.xmod.gregtech.common.render.GTPP_FlaskRenderer;
import gtPlusPlus.xmod.gregtech.common.render.GTPP_Render_MachineBlock;
import ic2.core.item.ItemFluidCell;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderFireball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class ClientProxy
extends CommonProxy
implements Runnable {
    private final GTPP_CapeRenderer mCapeRenderer = new GTPP_CapeRenderer();
    @SideOnly(value=Side.CLIENT)
    public static boolean mFancyGraphics = false;
    @SideOnly(value=Side.CLIENT)
    public static String playerName = "";

    public ClientProxy() {
        mFancyGraphics = Minecraft.func_71375_t();
    }

    @SubscribeEvent
    public void receiveRenderSpecialsEvent(RenderPlayerEvent.Specials.Pre aEvent) {
        if (CORE.ConfigSwitches.enableCustomCapes) {
            this.mCapeRenderer.receiveRenderSpecialsEvent(aEvent);
        }
    }

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        if (CORE.ConfigSwitches.enableCustomCapes) {
            this.onPreLoad();
        }
        GTplusplus.loadTextures();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        new CustomOreBlockRenderer();
        new CustomItemBlockRenderer();
        new GTPP_Render_MachineBlock();
        new GTPP_FlaskRenderer();
        MinecraftForge.EVENT_BUS.register((Object)new NEI_GTPP_Config());
        super.init(e);
    }

    @Override
    public void postInit(FMLPostInitializationEvent e) {
        super.postInit(e);
    }

    @Override
    public void registerRenderThings() {
        RenderingRegistry.registerEntityRenderingHandler(EntityPrimedMiningExplosive.class, (Render)new RenderMiningExplosivesPrimed());
        RenderingRegistry.registerEntityRenderingHandler(EntitySickBlaze.class, (Render)new RenderSickBlaze());
        RenderingRegistry.registerEntityRenderingHandler(EntityStaballoyConstruct.class, (Render)new RenderStaballoyConstruct());
        RenderingRegistry.registerEntityRenderingHandler(EntityToxinballSmall.class, (Render)new RenderToxinball(1.0f));
        RenderingRegistry.registerEntityRenderingHandler(EntityLightningAttack.class, (Render)new RenderFireball(1.0f));
        Logger.INFO("Registering Custom Renderer for the Lead Lined Chest.");
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDecayablesChest.class, (TileEntitySpecialRenderer)new RenderDecayChest());
        Logger.INFO("Registering Custom Renderer for the Egg Box.");
        for (Pair sItemRenderMappings : this.mItemRenderMappings) {
            MinecraftForgeClient.registerItemRenderer((Item)((Item)sItemRenderMappings.getKey()), (IItemRenderer)((IItemRenderer)sItemRenderMappings.getValue()));
        }
    }

    @Override
    public int addArmor(String armor) {
        return RenderingRegistry.addNewArmourRendererPrefix((String)armor);
    }

    @Override
    public void serverStarting(FMLServerStartingEvent e) {
    }

    public void onPreLoad() {
    }

    @Override
    public void run() {
    }

    @Override
    public void onLoadComplete(FMLLoadCompleteEvent event) {
        if (CORE.ConfigSwitches.hideUniversalCells) {
            this.hideUniversalCells();
        }
        super.onLoadComplete(event);
    }

    public void hideUniversalCells() {
        ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            if (fluid == null) continue;
            itemList.add(ItemFluidCell.getUniversalFluidCell((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE)));
        }
        for (ItemStack aCell : itemList) {
            API.hideItem((ItemStack)aCell);
        }
    }

    @Override
    public World getClientWorld() {
        return FMLClientHandler.instance().getClient().field_71441_e;
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }
}

