/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.item.base.CoreItem;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityBeacon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class ItemMagicFeather
extends CoreItem {
    public static final String NAME = "magicfeather";
    private static final WeakHashMap<EntityPlayer, MagicFeatherData> sPlayerData = new WeakHashMap();
    private static final WeakHashMap<EntityPlayer, HashSet<TileEntityBeacon>> sBeaconData = new WeakHashMap();

    public ItemMagicFeather() {
        super(NAME, AddToCreativeTab.tabMisc, 1, 100, new String[]{"Lets you fly around Beacons"}, EnumRarity.uncommon, null, false, null);
        this.func_77625_d(1);
        this.func_77655_b(Mods.GTPlusPlus.ID + ":" + NAME);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public int getEntityLifespan(ItemStack itemStack, World world) {
        return Integer.MAX_VALUE;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer aPlayer, List list, boolean bool) {
        list.add("Does not need to be the item held in your hand to work");
        super.func_77624_a(stack, aPlayer, list, bool);
        list.add("Needs to be within beacon range");
        list.add("Range is beacon level * 10 + 10");
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    private static boolean isInBeaconRange(EntityPlayer player) {
        World world = player.func_130014_f_();
        if (world.field_72995_K) {
            return false;
        }
        HashSet aBeaconData = sBeaconData.computeIfAbsent(player, k -> new HashSet());
        int chunkXlo = (int)(player.field_70165_t - 50.0) >> 4;
        int chunkXhi = (int)(player.field_70165_t + 50.0) >> 4;
        int chunkZlo = (int)(player.field_70161_v - 50.0) >> 4;
        int chunkZhi = (int)(player.field_70161_v + 50.0) >> 4;
        for (int chunkX = chunkXlo; chunkX < chunkXhi; ++chunkX) {
            for (int chunkZ = chunkZlo; chunkZ < chunkZhi; ++chunkZ) {
                if (!world.func_72863_F().func_73149_a(chunkX, chunkZ)) continue;
                ItemMagicFeather.findSuitableBeacon(player, world.func_72964_e((int)chunkX, (int)chunkZ).field_150816_i.values(), aBeaconData);
            }
        }
        return aBeaconData.size() > 0;
    }

    private static void findSuitableBeacon(EntityPlayer player, Collection<TileEntity> tileEntities, HashSet<TileEntityBeacon> aBeaconData) {
        for (TileEntity t : tileEntities) {
            TileEntityBeacon beacon;
            int level;
            if (!(t instanceof TileEntityBeacon) || (level = (beacon = (TileEntityBeacon)t).func_145998_l()) == 0) continue;
            int radius = level * 10 + 10;
            int x = beacon.field_145851_c;
            int z = beacon.field_145849_e;
            if (player.field_70165_t < (double)(x - radius) || player.field_70165_t > (double)(x + radius) || player.field_70161_v < (double)(z - radius) || player.field_70161_v > (double)(z + radius)) continue;
            aBeaconData.add(beacon);
        }
    }

    private static void setMayFly(EntityPlayer player, boolean mayFly) {
        if (player.field_71075_bZ.field_75101_c == mayFly) {
            return;
        }
        if (!mayFly) {
            player.field_71075_bZ.field_75100_b = false;
            if (player.field_70122_E && player.field_70143_R < 1.0f) {
                player.field_71075_bZ.field_75101_c = false;
            }
        } else {
            player.field_71075_bZ.field_75101_c = true;
        }
        player.func_71016_p();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        MagicFeatherData data;
        boolean hasItem;
        if (event.side != Side.SERVER || event.phase != TickEvent.Phase.END) {
            return;
        }
        EntityPlayer player = event.player;
        HashSet<TileEntityBeacon> aBeaconData = sBeaconData.get(player);
        if (aBeaconData != null && !aBeaconData.isEmpty()) {
            Iterator<TileEntityBeacon> iterator = aBeaconData.iterator();
            while (iterator.hasNext()) {
                TileEntityBeacon aBeacon = iterator.next();
                int level = aBeacon.func_145998_l();
                if (level == 0) {
                    iterator.remove();
                    continue;
                }
                int radius = level * 10 + 10;
                int x = aBeacon.field_145851_c;
                int z = aBeacon.field_145849_e;
                if (!(player.field_70165_t < (double)(x - radius) || player.field_70165_t > (double)(x + radius) || player.field_70161_v < (double)(z - radius)) && !(player.field_70161_v > (double)(z + radius))) continue;
                iterator.remove();
            }
        }
        if (!(hasItem = ItemMagicFeather.hasItem(player, ModItems.itemMagicFeather))) {
            sPlayerData.remove(player);
        }
        if ((data = sPlayerData.get(player)) == null) {
            data = new MagicFeatherData(player);
            sPlayerData.put(player, data);
        }
        data.onTick();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        EntityPlayer aPlayer;
        block5: {
            block4: {
                if (event.entityLiving == null) {
                    return;
                }
                EntityLivingBase aEntity = event.entityLiving;
                if (!(aEntity instanceof EntityPlayer)) break block4;
                aPlayer = (EntityPlayer)aEntity;
                if (aEntity.field_70170_p != null && !aEntity.field_70170_p.field_72995_K) break block5;
            }
            return;
        }
        sPlayerData.remove(aPlayer);
        sBeaconData.remove(aPlayer);
    }

    private static boolean hasItem(EntityPlayer player, Item item) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack == null || stack.func_77973_b() == null || !(stack.func_77973_b() instanceof ItemMagicFeather)) continue;
            return true;
        }
        return false;
    }

    private static class MagicFeatherData {
        private final WeakReference<EntityPlayer> player;
        private boolean hasItem = false;
        private int checkTick = 0;
        private boolean beaconInRangeCache;

        public MagicFeatherData(EntityPlayer player) {
            this.player = new WeakReference<EntityPlayer>(player);
            this.beaconInRangeCache = player.field_71075_bZ.field_75101_c;
        }

        public void onTick() {
            EntityPlayer player = (EntityPlayer)this.player.get();
            if (player == null) {
                return;
            }
            try {
                boolean hasItem = ItemMagicFeather.hasItem(player, ModItems.itemMagicFeather);
                if (hasItem != this.hasItem) {
                    if (hasItem) {
                        this.onAdd();
                    }
                    if (!hasItem) {
                        this.onRemove();
                    }
                    this.hasItem = hasItem;
                    Logger.INFO("Ticking feather " + hasItem);
                    return;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (this.hasItem) {
                boolean mayFly = player.field_71075_bZ.field_75098_d || this.checkBeaconInRange(player);
                ItemMagicFeather.setMayFly(player, mayFly);
            }
        }

        private void onAdd() {
            if (!ItemMagicFeather.isInBeaconRange(this.getPlayer())) {
                return;
            }
            ItemMagicFeather.setMayFly(this.getPlayer(), true);
        }

        private void onRemove() {
            if (this.getPlayer().field_71075_bZ.field_75098_d) {
                return;
            }
            ItemMagicFeather.setMayFly(this.getPlayer(), false);
        }

        private boolean checkBeaconInRange(EntityPlayer player) {
            if (this.checkTick++ % 40 != 0) {
                return this.beaconInRangeCache;
            }
            this.beaconInRangeCache = ItemMagicFeather.isInBeaconRange(player);
            return this.beaconInRangeCache;
        }

        private EntityPlayer getPlayer() {
            return (EntityPlayer)this.player.get();
        }
    }
}

