/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.machine;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Mods;
import gtPlusPlus.GTplusplus;
import gtPlusPlus.api.interfaces.ITileTooltip;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.base.itemblock.ItemBlockBasicTile;
import gtPlusPlus.core.tileentities.machines.TileEntityProjectTable;
import gtPlusPlus.core.util.minecraft.PlayerUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import ic2.core.item.tool.ItemToolWrench;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@Optional.Interface(iface="crazypants.enderio.api.tool.ITool", modid="EnderIO")
public class Machine_ProjectTable
extends BlockContainer
implements ITileTooltip {
    @SideOnly(value=Side.CLIENT)
    private IIcon textureTop;
    @SideOnly(value=Side.CLIENT)
    private IIcon textureBottom;
    @SideOnly(value=Side.CLIENT)
    private IIcon textureFront;
    private final int mTooltipID = 3;

    @Override
    public int getTooltipID() {
        return this.mTooltipID;
    }

    public Machine_ProjectTable() {
        super(Material.field_151573_f);
        this.func_149663_c("blockProjectBench");
        this.func_149647_a(AddToCreativeTab.tabMachines);
        GameRegistry.registerBlock((Block)this, ItemBlockBasicTile.class, (String)"blockProjectBench");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int ordinalSide, int meta) {
        return ordinalSide == 1 ? this.textureTop : (ordinalSide == 0 ? this.textureBottom : (ordinalSide != 2 && ordinalSide != 4 ? this.field_149761_L : this.textureFront));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister p_149651_1_) {
        this.field_149761_L = p_149651_1_.func_94245_a(Mods.GTPlusPlus.ID + ":TileEntities/machine_top");
        this.textureTop = p_149651_1_.func_94245_a(Mods.GTPlusPlus.ID + ":TileEntities/cover_crafting");
        this.textureBottom = p_149651_1_.func_94245_a(Mods.GTPlusPlus.ID + ":TileEntities/machine_top");
        this.textureFront = p_149651_1_.func_94245_a(Mods.GTPlusPlus.ID + ":TileEntities/machine_top");
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float lx, float ly, float lz) {
        ItemStack heldItem = null;
        if (world.field_72995_K) {
            heldItem = PlayerUtils.getItemStackInPlayersHand();
        }
        boolean holdingWrench = false;
        if (heldItem != null) {
            holdingWrench = Machine_ProjectTable.isWrench(heldItem);
        }
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntityProjectTable) {
            if (!holdingWrench) {
                player.openGui((Object)GTplusplus.instance, 0, world, x, y, z);
                return true;
            }
            Logger.INFO("Holding a Wrench, doing wrench things instead.");
        }
        return false;
    }

    public TileEntity func_149915_a(World world, int p_149915_2_) {
        return new TileEntityProjectTable();
    }

    public static boolean isWrench(ItemStack item) {
        if (item.func_77973_b() instanceof ItemToolWrench) {
            return true;
        }
        if (Mods.BuildCraftCore.isModLoaded()) {
            return Machine_ProjectTable.checkBuildcraftWrench(item);
        }
        if (Mods.EnderIO.isModLoaded()) {
            return Machine_ProjectTable.checkEnderIOWrench(item);
        }
        return false;
    }

    private static boolean checkEnderIOWrench(ItemStack item) {
        Class<?> wrenchClass;
        return ReflectionUtils.doesClassExist("crazypants.enderio.api.tool.ITool") && (wrenchClass = ReflectionUtils.getClass("crazypants.enderio.api.tool.ITool")).isInstance(item.func_77973_b());
    }

    private static boolean checkBuildcraftWrench(ItemStack item) {
        Class<?> wrenchClass;
        return ReflectionUtils.doesClassExist("buildcraft.api.tools.IToolWrench") && (wrenchClass = ReflectionUtils.getClass("buildcraft.api.tools.IToolWrench")).isInstance(item.func_77973_b());
    }

    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }
}

