/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.block.base;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.util.GT_OreDictUnificator;
import gtPlusPlus.api.interfaces.ITexturedBlock;
import gtPlusPlus.core.block.base.BasicBlock;
import gtPlusPlus.core.client.renderer.CustomOreBlockRenderer;
import gtPlusPlus.core.item.base.itemblock.ItemBlockOre;
import gtPlusPlus.core.util.Utils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import gtPlusPlus.core.util.reflect.ReflectionUtils;
import gtPlusPlus.xmod.gregtech.api.objects.GTPP_CopiedBlockTexture;
import gtPlusPlus.xmod.gregtech.api.objects.GTPP_RenderedTexture;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBaseOre
extends BasicBlock
implements ITexturedBlock {
    private final gtPlusPlus.core.material.Material blockMaterial;
    public static IIconContainer[] hiddenTextureArray;

    public BlockBaseOre(gtPlusPlus.core.material.Material material, BasicBlock.BlockTypes blockType) {
        super(blockType, Utils.sanitizeString(material.getUnlocalizedName()), Material.field_151576_e, Math.min(Math.max(material.vTier, 1), 6));
        int aMaterialTierForMining = Math.min(Math.max(material.vTier, 1), 6);
        this.blockMaterial = material;
        this.func_149711_c(1.0f * (float)aMaterialTierForMining);
        this.func_149752_b(6.0f);
        this.func_149715_a(0.0f);
        this.setHarvestLevel("pickaxe", aMaterialTierForMining);
        this.func_149672_a(field_149769_e);
        this.func_149663_c("Ore" + Utils.sanitizeString(Utils.sanitizeString(material.getUnlocalizedName())));
        this.func_149658_d("stone");
        try {
            GameRegistry.registerBlock((Block)this, ItemBlockOre.class, (String)Utils.sanitizeString("ore" + Utils.sanitizeString(this.blockMaterial.getLocalizedName())));
            GT_OreDictUnificator.registerOre((Object)("ore" + Utils.sanitizeString(this.blockMaterial.getLocalizedName())), (ItemStack)ItemUtils.getSimpleStack((Block)this));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    @Override
    public boolean canCreatureSpawn(EnumCreatureType type, IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public gtPlusPlus.core.material.Material getMaterialEx() {
        return this.blockMaterial;
    }

    public int func_149645_b() {
        try {
            if (CustomOreBlockRenderer.INSTANCE != null) {
                return CustomOreBlockRenderer.INSTANCE.mRenderID;
            }
            return super.func_149645_b();
        }
        catch (NullPointerException n) {
            return 0;
        }
    }

    public IIcon func_149673_e(IBlockAccess aIBlockAccess, int aX, int aY, int aZ, int ordinalSide) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    public IIcon func_149691_a(int ordinalSide, int aMeta) {
        return Blocks.field_150348_b.func_149691_a(0, 0);
    }

    @Override
    public ITexture[] getTexture(ForgeDirection side) {
        return this.getTexture(null, side);
    }

    @Override
    public ITexture[] getTexture(Block block, ForgeDirection side) {
        if (this.blockMaterial != null) {
            GTPP_RenderedTexture aIconSet = new GTPP_RenderedTexture(this.blockMaterial.getTextureSet().mTextures[OrePrefixes.ore.mTextureIndex], this.blockMaterial.getRGBA());
            return new ITexture[]{new GTPP_CopiedBlockTexture(Blocks.field_150348_b, 0, 0), aIconSet};
        }
        if (hiddenTextureArray == null) {
            try {
                Field o = ReflectionUtils.getField(Textures.BlockIcons.class, "STONES");
                if (o != null) {
                    hiddenTextureArray = (IIconContainer[])o.get(Textures.BlockIcons.class);
                }
                if (hiddenTextureArray == null) {
                    hiddenTextureArray = new IIconContainer[6];
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                hiddenTextureArray = new IIconContainer[6];
            }
        }
        return new ITexture[]{new GTPP_RenderedTexture(hiddenTextureArray[0], new short[]{240, 240, 240, 0})};
    }

    public void func_149651_a(IIconRegister p_149651_1_) {
    }
}

