/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.api.objects.data;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class AutoMap<V>
implements Iterable<V>,
Cloneable,
Serializable,
Collection<V>,
Queue<V>,
List<V> {
    protected final Map<Integer, V> mInternalMap;
    protected final Map<String, Integer> mInternalNameMap;
    private int mInternalID = 0;
    private static final long serialVersionUID = 3771412318075131790L;

    public AutoMap() {
        this(new LinkedHashMap());
    }

    public Map<Integer, V> getMap() {
        return this.mInternalMap;
    }

    public AutoMap(Map<Integer, V> defaultMapType) {
        this.mInternalMap = defaultMapType;
        this.mInternalNameMap = new LinkedHashMap<String, Integer>();
    }

    public AutoMap(List<V> aList) {
        this.mInternalMap = new LinkedHashMap<Integer, V>();
        this.mInternalNameMap = new LinkedHashMap<String, Integer>();
        if (aList != null && aList.size() > 0) {
            for (V obj : aList) {
                this.add(obj);
            }
        }
    }

    public AutoMap(Set<V> aList) {
        this.mInternalMap = new LinkedHashMap<Integer, V>();
        this.mInternalNameMap = new LinkedHashMap<String, Integer>();
        if (aList != null && aList.size() > 0) {
            for (V obj : aList) {
                this.add(obj);
            }
        }
    }

    public AutoMap(Collection<V> aList) {
        this.mInternalMap = new LinkedHashMap<Integer, V>();
        this.mInternalNameMap = new LinkedHashMap<String, Integer>();
        if (aList != null && aList.size() > 0) {
            for (V obj : aList) {
                this.add(obj);
            }
        }
    }

    public AutoMap(V[] aArray) {
        this.mInternalMap = new LinkedHashMap<Integer, V>();
        this.mInternalNameMap = new LinkedHashMap<String, Integer>();
        if (aArray != null && aArray.length > 0) {
            for (V obj : aArray) {
                this.add(obj);
            }
        }
    }

    @Override
    public Iterator<V> iterator() {
        return this.values().iterator();
    }

    public synchronized boolean setValue(V object) {
        int mOriginalID = this.mInternalID;
        this.put(object);
        return this.mInternalMap.get(mOriginalID).equals(object) || mOriginalID > this.mInternalID;
    }

    public synchronized V put(V object) {
        return this.set(object);
    }

    @Override
    public synchronized boolean add(V object) {
        return this.set(object) != null;
    }

    public synchronized V set(V object) {
        if (object == null) {
            return null;
        }
        this.mInternalNameMap.put("" + object.hashCode(), this.mInternalID + 1);
        return this.mInternalMap.put(this.mInternalID++, object);
    }

    @Override
    public synchronized V get(int id) {
        return this.mInternalMap.get(id);
    }

    public synchronized Collection<V> values() {
        return this.mInternalMap.values();
    }

    @Override
    public synchronized int size() {
        return this.mInternalMap.size();
    }

    @Override
    public synchronized int hashCode() {
        return this.mInternalMap.hashCode();
    }

    public synchronized boolean containsKey(int key) {
        return this.mInternalMap.containsKey(key);
    }

    public synchronized boolean containsValue(V value) {
        return this.mInternalMap.containsValue(value);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.mInternalMap.isEmpty();
    }

    @Override
    public synchronized void clear() {
        this.mInternalID = 0;
        this.mInternalMap.clear();
        this.mInternalNameMap.clear();
    }

    @Override
    public V[] toArray() {
        Object[] toR = (Object[])Array.newInstance(this.mInternalMap.get(0).getClass(), this.mInternalMap.size());
        for (int i = 0; i < this.mInternalMap.size(); ++i) {
            toR[i] = this.mInternalMap.get(i);
        }
        return toR;
    }

    public final synchronized int getInternalID() {
        return this.mInternalID;
    }

    @Override
    public final synchronized boolean remove(Object value) {
        value.getClass();
        if (this.mInternalMap.containsValue(value)) {
            return this.mInternalMap.remove(this.mInternalNameMap.get("" + value.hashCode()), value);
        }
        return false;
    }

    @Override
    public boolean contains(Object o) {
        for (V g : this.mInternalMap.values()) {
            if (!g.equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <V> V[] toArray(V[] a) {
        return this.toArray();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        boolean aTrue = true;
        for (Object g : c) {
            if (this.contains(g)) continue;
            aTrue = false;
        }
        return aTrue;
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        boolean aTrue = true;
        for (V g : c) {
            if (this.add(g)) continue;
            aTrue = false;
        }
        return aTrue;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean aTrue = true;
        for (Object g : c) {
            if (this.remove(g)) continue;
            aTrue = false;
        }
        return aTrue;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        AutoMap aTempAllocation = new AutoMap();
        boolean aTrue = false;
        aTempAllocation = this;
        aTempAllocation.removeAll(c);
        aTempAllocation.clear();
        aTrue = aTempAllocation.isEmpty();
        aTempAllocation.clear();
        return aTrue;
    }

    @Override
    public boolean offer(V e) {
        return this.add(e);
    }

    @Override
    public V remove() {
        V y = this.get(0);
        if (this.remove(y)) {
            return y;
        }
        return null;
    }

    @Override
    public V poll() {
        if (this.mInternalMap.isEmpty()) {
            return null;
        }
        return this.remove();
    }

    @Override
    public V element() {
        if (this.mInternalMap.isEmpty()) {
            return null;
        }
        return this.get(0);
    }

    @Override
    public V peek() {
        return this.element();
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        for (V y : c) {
            this.add(y);
        }
        return true;
    }

    @Override
    public V set(int index, V element) {
        return this.mInternalMap.put(index, element);
    }

    @Override
    public void add(int index, V element) {
        this.add(element);
    }

    @Override
    public V remove(int index) {
        V h = this.mInternalMap.get(index);
        this.set(index, (V)null);
        return h;
    }

    @Override
    public int indexOf(Object o) {
        int aCount = 0;
        for (V of : this.mInternalMap.values()) {
            if (of != o) {
                ++aCount;
                continue;
            }
            return aCount;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.indexOf(o);
    }

    @Override
    public ListIterator<V> listIterator() {
        return null;
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        return null;
    }

    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        AutoMap<V> aNewSubList = new AutoMap<V>();
        for (int slot = fromIndex; slot <= toIndex; ++slot) {
            V obj = this.mInternalMap.get(slot);
            if (obj == null) continue;
            aNewSubList.put(obj);
        }
        return aNewSubList;
    }
}

